/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import junit.framework.TestCase;
import org.apache.commons.lang3.mutable.MutableByte;

public class MutableByteTest
extends TestCase {
    public MutableByteTest(String testName) {
        super(testName);
    }

    public void testConstructors() {
        MutableByteTest.assertEquals((byte)0, (byte)new MutableByte().byteValue());
        MutableByteTest.assertEquals((byte)1, (byte)new MutableByte(1).byteValue());
        MutableByteTest.assertEquals((byte)2, (byte)new MutableByte((Number)2).byteValue());
        MutableByteTest.assertEquals((byte)3, (byte)new MutableByte((Number)new MutableByte(3)).byteValue());
        MutableByteTest.assertEquals((byte)2, (byte)new MutableByte("2").byteValue());
        try {
            new MutableByte((Number)null);
            MutableByteTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetSet() {
        MutableByte mutNum = new MutableByte(0);
        MutableByteTest.assertEquals((byte)0, (byte)new MutableByte().byteValue());
        MutableByteTest.assertEquals((Object)0, (Object)new MutableByte().getValue());
        mutNum.setValue((byte)1);
        MutableByteTest.assertEquals((byte)1, (byte)mutNum.byteValue());
        MutableByteTest.assertEquals((Object)1, (Object)mutNum.getValue());
        mutNum.setValue((Number)2);
        MutableByteTest.assertEquals((byte)2, (byte)mutNum.byteValue());
        MutableByteTest.assertEquals((Object)2, (Object)mutNum.getValue());
        mutNum.setValue((Number)new MutableByte(3));
        MutableByteTest.assertEquals((byte)3, (byte)mutNum.byteValue());
        MutableByteTest.assertEquals((Object)3, (Object)mutNum.getValue());
        try {
            mutNum.setValue(null);
            MutableByteTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testEquals() {
        MutableByte mutNumA = new MutableByte(0);
        MutableByte mutNumB = new MutableByte(0);
        MutableByte mutNumC = new MutableByte(1);
        MutableByteTest.assertEquals((boolean)true, (boolean)mutNumA.equals((Object)mutNumA));
        MutableByteTest.assertEquals((boolean)true, (boolean)mutNumA.equals((Object)mutNumB));
        MutableByteTest.assertEquals((boolean)true, (boolean)mutNumB.equals((Object)mutNumA));
        MutableByteTest.assertEquals((boolean)true, (boolean)mutNumB.equals((Object)mutNumB));
        MutableByteTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)mutNumC));
        MutableByteTest.assertEquals((boolean)false, (boolean)mutNumB.equals((Object)mutNumC));
        MutableByteTest.assertEquals((boolean)true, (boolean)mutNumC.equals((Object)mutNumC));
        MutableByteTest.assertEquals((boolean)false, (boolean)mutNumA.equals(null));
        MutableByteTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)0));
        MutableByteTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)"0"));
    }

    public void testHashCode() {
        MutableByte mutNumA = new MutableByte(0);
        MutableByte mutNumB = new MutableByte(0);
        MutableByte mutNumC = new MutableByte(1);
        MutableByteTest.assertEquals((boolean)true, (mutNumA.hashCode() == mutNumA.hashCode() ? 1 : 0) != 0);
        MutableByteTest.assertEquals((boolean)true, (mutNumA.hashCode() == mutNumB.hashCode() ? 1 : 0) != 0);
        MutableByteTest.assertEquals((boolean)false, (mutNumA.hashCode() == mutNumC.hashCode() ? 1 : 0) != 0);
        MutableByteTest.assertEquals((boolean)true, (mutNumA.hashCode() == Byte.valueOf((byte)0).hashCode() ? 1 : 0) != 0);
    }

    public void testCompareTo() {
        MutableByte mutNum = new MutableByte(0);
        MutableByteTest.assertEquals((int)0, (int)mutNum.compareTo(new MutableByte(0)));
        MutableByteTest.assertEquals((int)1, (int)mutNum.compareTo(new MutableByte(-1)));
        MutableByteTest.assertEquals((int)-1, (int)mutNum.compareTo(new MutableByte(1)));
        try {
            mutNum.compareTo(null);
            MutableByteTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPrimitiveValues() {
        MutableByte mutNum = new MutableByte(1);
        MutableByteTest.assertEquals((float)1.0f, (float)mutNum.floatValue(), (float)0.0f);
        MutableByteTest.assertEquals((double)1.0, (double)mutNum.doubleValue(), (double)0.0);
        MutableByteTest.assertEquals((byte)1, (byte)mutNum.byteValue());
        MutableByteTest.assertEquals((short)1, (short)mutNum.shortValue());
        MutableByteTest.assertEquals((int)1, (int)mutNum.intValue());
        MutableByteTest.assertEquals((long)1L, (long)mutNum.longValue());
    }

    public void testToByte() {
        MutableByteTest.assertEquals((Object)0, (Object)new MutableByte(0).toByte());
        MutableByteTest.assertEquals((Object)123, (Object)new MutableByte(123).toByte());
    }

    public void testIncrement() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.increment();
        MutableByteTest.assertEquals((int)2, (int)mutNum.intValue());
        MutableByteTest.assertEquals((long)2L, (long)mutNum.longValue());
    }

    public void testDecrement() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.decrement();
        MutableByteTest.assertEquals((int)0, (int)mutNum.intValue());
        MutableByteTest.assertEquals((long)0L, (long)mutNum.longValue());
    }

    public void testAddValuePrimitive() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.add((byte)1);
        MutableByteTest.assertEquals((byte)2, (byte)mutNum.byteValue());
    }

    public void testAddValueObject() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.add((Number)1);
        MutableByteTest.assertEquals((byte)2, (byte)mutNum.byteValue());
    }

    public void testSubtractValuePrimitive() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.subtract((byte)1);
        MutableByteTest.assertEquals((byte)0, (byte)mutNum.byteValue());
    }

    public void testSubtractValueObject() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.subtract((Number)1);
        MutableByteTest.assertEquals((byte)0, (byte)mutNum.byteValue());
    }

    public void testToString() {
        MutableByteTest.assertEquals((String)"0", (String)new MutableByte(0).toString());
        MutableByteTest.assertEquals((String)"10", (String)new MutableByte(10).toString());
        MutableByteTest.assertEquals((String)"-123", (String)new MutableByte(-123).toString());
    }
}

