/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import junit.framework.TestCase;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class MutableBooleanTest
extends TestCase {
    public MutableBooleanTest(String testName) {
        super(testName);
    }

    public void testCompareTo() {
        MutableBoolean mutBool = new MutableBoolean(false);
        MutableBooleanTest.assertEquals((int)0, (int)mutBool.compareTo(new MutableBoolean(false)));
        MutableBooleanTest.assertEquals((int)-1, (int)mutBool.compareTo(new MutableBoolean(true)));
        mutBool.setValue(true);
        MutableBooleanTest.assertEquals((int)1, (int)mutBool.compareTo(new MutableBoolean(false)));
        MutableBooleanTest.assertEquals((int)0, (int)mutBool.compareTo(new MutableBoolean(true)));
        try {
            mutBool.compareTo(null);
            MutableBooleanTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructors() {
        MutableBooleanTest.assertEquals((boolean)false, (boolean)new MutableBoolean().booleanValue());
        MutableBooleanTest.assertEquals((boolean)true, (boolean)new MutableBoolean(true).booleanValue());
        MutableBooleanTest.assertEquals((boolean)false, (boolean)new MutableBoolean(false).booleanValue());
        MutableBooleanTest.assertEquals((boolean)true, (boolean)new MutableBoolean(Boolean.TRUE).booleanValue());
        MutableBooleanTest.assertEquals((boolean)false, (boolean)new MutableBoolean(Boolean.FALSE).booleanValue());
        try {
            new MutableBoolean(null);
            MutableBooleanTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testEquals() {
        MutableBoolean mutBoolA = new MutableBoolean(false);
        MutableBoolean mutBoolB = new MutableBoolean(false);
        MutableBoolean mutBoolC = new MutableBoolean(true);
        MutableBooleanTest.assertEquals((boolean)true, (boolean)mutBoolA.equals((Object)mutBoolA));
        MutableBooleanTest.assertEquals((boolean)true, (boolean)mutBoolA.equals((Object)mutBoolB));
        MutableBooleanTest.assertEquals((boolean)true, (boolean)mutBoolB.equals((Object)mutBoolA));
        MutableBooleanTest.assertEquals((boolean)true, (boolean)mutBoolB.equals((Object)mutBoolB));
        MutableBooleanTest.assertEquals((boolean)false, (boolean)mutBoolA.equals((Object)mutBoolC));
        MutableBooleanTest.assertEquals((boolean)false, (boolean)mutBoolB.equals((Object)mutBoolC));
        MutableBooleanTest.assertEquals((boolean)true, (boolean)mutBoolC.equals((Object)mutBoolC));
        MutableBooleanTest.assertEquals((boolean)false, (boolean)mutBoolA.equals(null));
        MutableBooleanTest.assertEquals((boolean)false, (boolean)mutBoolA.equals((Object)Boolean.FALSE));
        MutableBooleanTest.assertEquals((boolean)false, (boolean)mutBoolA.equals((Object)"false"));
    }

    public void testGetSet() {
        MutableBooleanTest.assertEquals((boolean)false, (boolean)new MutableBoolean().booleanValue());
        MutableBooleanTest.assertEquals((Object)Boolean.FALSE, (Object)new MutableBoolean().getValue());
        MutableBoolean mutBool = new MutableBoolean(false);
        MutableBooleanTest.assertEquals((Object)Boolean.FALSE, (Object)mutBool.toBoolean());
        MutableBooleanTest.assertEquals((boolean)false, (boolean)mutBool.booleanValue());
        MutableBooleanTest.assertEquals((boolean)true, (boolean)mutBool.isFalse());
        MutableBooleanTest.assertEquals((boolean)false, (boolean)mutBool.isTrue());
        mutBool.setValue(Boolean.TRUE);
        MutableBooleanTest.assertEquals((Object)Boolean.TRUE, (Object)mutBool.toBoolean());
        MutableBooleanTest.assertEquals((boolean)true, (boolean)mutBool.booleanValue());
        MutableBooleanTest.assertEquals((boolean)false, (boolean)mutBool.isFalse());
        MutableBooleanTest.assertEquals((boolean)true, (boolean)mutBool.isTrue());
        mutBool.setValue(false);
        MutableBooleanTest.assertEquals((boolean)false, (boolean)mutBool.booleanValue());
        mutBool.setValue(true);
        MutableBooleanTest.assertEquals((boolean)true, (boolean)mutBool.booleanValue());
        try {
            mutBool.setValue(null);
            MutableBooleanTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testHashCode() {
        MutableBoolean mutBoolA = new MutableBoolean(false);
        MutableBoolean mutBoolB = new MutableBoolean(false);
        MutableBoolean mutBoolC = new MutableBoolean(true);
        MutableBooleanTest.assertEquals((boolean)true, (mutBoolA.hashCode() == mutBoolA.hashCode() ? 1 : 0) != 0);
        MutableBooleanTest.assertEquals((boolean)true, (mutBoolA.hashCode() == mutBoolB.hashCode() ? 1 : 0) != 0);
        MutableBooleanTest.assertEquals((boolean)false, (mutBoolA.hashCode() == mutBoolC.hashCode() ? 1 : 0) != 0);
        MutableBooleanTest.assertEquals((boolean)true, (mutBoolA.hashCode() == Boolean.FALSE.hashCode() ? 1 : 0) != 0);
        MutableBooleanTest.assertEquals((boolean)true, (mutBoolC.hashCode() == Boolean.TRUE.hashCode() ? 1 : 0) != 0);
    }

    public void testToString() {
        MutableBooleanTest.assertEquals((String)Boolean.FALSE.toString(), (String)new MutableBoolean(false).toString());
        MutableBooleanTest.assertEquals((String)Boolean.TRUE.toString(), (String)new MutableBoolean(true).toString());
    }
}

