/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import junit.framework.TestCase;
import org.apache.commons.lang3.math.IEEE754rUtils;

public class IEEE754rUtilsTest
extends TestCase {
    public void testLang381() {
        IEEE754rUtilsTest.assertEquals((double)1.2, (double)IEEE754rUtils.min((double)1.2, (double)2.5, (double)Double.NaN), (double)0.01);
        IEEE754rUtilsTest.assertEquals((double)2.5, (double)IEEE754rUtils.max((double)1.2, (double)2.5, (double)Double.NaN), (double)0.01);
        IEEE754rUtilsTest.assertTrue((boolean)Double.isNaN(IEEE754rUtils.max((double)Double.NaN, (double)Double.NaN, (double)Double.NaN)));
        IEEE754rUtilsTest.assertEquals((double)1.2f, (double)IEEE754rUtils.min((float)1.2f, (float)2.5f, (float)Float.NaN), (double)0.01);
        IEEE754rUtilsTest.assertEquals((double)2.5, (double)IEEE754rUtils.max((float)1.2f, (float)2.5f, (float)Float.NaN), (double)0.01);
        IEEE754rUtilsTest.assertTrue((boolean)Float.isNaN(IEEE754rUtils.max((float)Float.NaN, (float)Float.NaN, (float)Float.NaN)));
        double[] a = new double[]{1.2, Double.NaN, 3.7, 27.0, 42.0, Double.NaN};
        IEEE754rUtilsTest.assertEquals((double)42.0, (double)IEEE754rUtils.max((double[])a), (double)0.01);
        IEEE754rUtilsTest.assertEquals((double)1.2, (double)IEEE754rUtils.min((double[])a), (double)0.01);
        double[] b = new double[]{Double.NaN, 1.2, Double.NaN, 3.7, 27.0, 42.0, Double.NaN};
        IEEE754rUtilsTest.assertEquals((double)42.0, (double)IEEE754rUtils.max((double[])b), (double)0.01);
        IEEE754rUtilsTest.assertEquals((double)1.2, (double)IEEE754rUtils.min((double[])b), (double)0.01);
        float[] aF = new float[]{1.2f, Float.NaN, 3.7f, 27.0f, 42.0f, Float.NaN};
        IEEE754rUtilsTest.assertEquals((double)1.2f, (double)IEEE754rUtils.min((float[])aF), (double)0.01);
        IEEE754rUtilsTest.assertEquals((double)42.0, (double)IEEE754rUtils.max((float[])aF), (double)0.01);
        float[] bF = new float[]{Float.NaN, 1.2f, Float.NaN, 3.7f, 27.0f, 42.0f, Float.NaN};
        IEEE754rUtilsTest.assertEquals((double)1.2f, (double)IEEE754rUtils.min((float[])bF), (double)0.01);
        IEEE754rUtilsTest.assertEquals((double)42.0, (double)IEEE754rUtils.max((float[])bF), (double)0.01);
    }

    public void testEnforceExceptions() {
        try {
            IEEE754rUtils.min((float[])null);
            IEEE754rUtilsTest.fail((String)"IllegalArgumentException expected for null input");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            IEEE754rUtils.min((float[])new float[0]);
            IEEE754rUtilsTest.fail((String)"IllegalArgumentException expected for empty input");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            IEEE754rUtils.max((float[])null);
            IEEE754rUtilsTest.fail((String)"IllegalArgumentException expected for null input");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            IEEE754rUtils.max((float[])new float[0]);
            IEEE754rUtilsTest.fail((String)"IllegalArgumentException expected for empty input");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            IEEE754rUtils.min((double[])null);
            IEEE754rUtilsTest.fail((String)"IllegalArgumentException expected for null input");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            IEEE754rUtils.min((double[])new double[0]);
            IEEE754rUtilsTest.fail((String)"IllegalArgumentException expected for empty input");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            IEEE754rUtils.max((double[])null);
            IEEE754rUtilsTest.fail((String)"IllegalArgumentException expected for null input");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            IEEE754rUtils.max((double[])new double[0]);
            IEEE754rUtilsTest.fail((String)"IllegalArgumentException expected for empty input");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorExists() {
        new IEEE754rUtils();
    }
}

