/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.AbstractExceptionContextTest;
import org.apache.commons.lang3.exception.ContextedException;
import org.apache.commons.lang3.exception.DefaultExceptionContext;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextedExceptionTest
extends AbstractExceptionContextTest<ContextedException> {
    @Override
    public void setUp() throws Exception {
        this.exceptionContext = new ContextedException((Throwable)new Exception("Test Message"));
        super.setUp();
    }

    public void testContextedException() {
        this.exceptionContext = new ContextedException();
        String message = ((ContextedException)this.exceptionContext).getMessage();
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        ContextedExceptionTest.assertTrue((trace.indexOf("ContextedException") >= 0 ? 1 : 0) != 0);
        ContextedExceptionTest.assertTrue((boolean)StringUtils.isEmpty((CharSequence)message));
    }

    public void testContextedExceptionString() {
        this.exceptionContext = new ContextedException("Test Message");
        ContextedExceptionTest.assertEquals((String)"Test Message", (String)((ContextedException)this.exceptionContext).getMessage());
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        ContextedExceptionTest.assertTrue((trace.indexOf("Test Message") >= 0 ? 1 : 0) != 0);
    }

    public void testContextedExceptionThrowable() {
        this.exceptionContext = new ContextedException((Throwable)new Exception("Test Message"));
        String message = ((ContextedException)this.exceptionContext).getMessage();
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        ContextedExceptionTest.assertTrue((trace.indexOf("ContextedException") >= 0 ? 1 : 0) != 0);
        ContextedExceptionTest.assertTrue((trace.indexOf("Test Message") >= 0 ? 1 : 0) != 0);
        ContextedExceptionTest.assertTrue((message.indexOf("Test Message") >= 0 ? 1 : 0) != 0);
    }

    public void testContextedExceptionStringThrowable() {
        this.exceptionContext = new ContextedException("This is monotonous", (Throwable)new Exception("Test Message"));
        String message = ((ContextedException)this.exceptionContext).getMessage();
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        ContextedExceptionTest.assertTrue((trace.indexOf("ContextedException") >= 0 ? 1 : 0) != 0);
        ContextedExceptionTest.assertTrue((trace.indexOf("Test Message") >= 0 ? 1 : 0) != 0);
        ContextedExceptionTest.assertTrue((trace.indexOf("This is monotonous") >= 0 ? 1 : 0) != 0);
        ContextedExceptionTest.assertTrue((message.indexOf("This is monotonous") >= 0 ? 1 : 0) != 0);
    }

    public void testContextedExceptionStringThrowableContext() {
        this.exceptionContext = new ContextedException("This is monotonous", (Throwable)new Exception("Test Message"), (ExceptionContext)new DefaultExceptionContext());
        String message = ((ContextedException)this.exceptionContext).getMessage();
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        ContextedExceptionTest.assertTrue((trace.indexOf("ContextedException") >= 0 ? 1 : 0) != 0);
        ContextedExceptionTest.assertTrue((trace.indexOf("Test Message") >= 0 ? 1 : 0) != 0);
        ContextedExceptionTest.assertTrue((trace.indexOf("This is monotonous") >= 0 ? 1 : 0) != 0);
        ContextedExceptionTest.assertTrue((message.indexOf("This is monotonous") >= 0 ? 1 : 0) != 0);
    }

    public void testNullExceptionPassing() {
        this.exceptionContext = new ContextedException("This is monotonous", (Throwable)new Exception("Test Message"), null).addContextValue("test1", null).addContextValue("test2", (Object)"some value").addContextValue("test Date", (Object)new Date()).addContextValue("test Nbr", (Object)5).addContextValue("test Poorly written obj", (Object)new AbstractExceptionContextTest.ObjectWithFaultyToString());
        String message = ((ContextedException)this.exceptionContext).getMessage();
        ContextedExceptionTest.assertTrue((message != null ? 1 : 0) != 0);
    }

    public void testRawMessage() {
        ContextedExceptionTest.assertEquals((String)(Exception.class.getName() + ": " + "Test Message"), (String)((ContextedException)this.exceptionContext).getRawMessage());
        this.exceptionContext = new ContextedException("This is monotonous", (Throwable)new Exception("Test Message"), (ExceptionContext)new DefaultExceptionContext());
        ContextedExceptionTest.assertEquals((String)"This is monotonous", (String)((ContextedException)this.exceptionContext).getRawMessage());
        this.exceptionContext = new ContextedException(null, (Throwable)new Exception("Test Message"), (ExceptionContext)new DefaultExceptionContext());
        ContextedExceptionTest.assertNull((Object)((ContextedException)this.exceptionContext).getRawMessage());
    }
}

