/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.lang3.event.EventListenerSupport;
import org.easymock.EasyMock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListenerSupportTest
extends TestCase {
    public void testAddNullListener() {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        try {
            listenerSupport.addListener(null);
            EventListenerSupportTest.fail((String)"Should not be able to add a null listener.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemoveNullListener() {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        try {
            listenerSupport.removeListener(null);
            EventListenerSupportTest.fail((String)"Should not be able to remove a null listener.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testEventDispatchOrder() throws PropertyVetoException {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        ArrayList<VetoableChangeListener> calledListeners = new ArrayList<VetoableChangeListener>();
        VetoableChangeListener listener1 = this.createListener(calledListeners);
        VetoableChangeListener listener2 = this.createListener(calledListeners);
        listenerSupport.addListener((Object)listener1);
        listenerSupport.addListener((Object)listener2);
        ((VetoableChangeListener)listenerSupport.fire()).vetoableChange(new PropertyChangeEvent(new Date(), "Day", 4, 5));
        EventListenerSupportTest.assertEquals((int)calledListeners.size(), (int)2);
        EventListenerSupportTest.assertSame(calledListeners.get(0), (Object)listener1);
        EventListenerSupportTest.assertSame(calledListeners.get(1), (Object)listener2);
    }

    public void testCreateWithNonInterfaceParameter() {
        try {
            EventListenerSupport.create(String.class);
            EventListenerSupportTest.fail((String)"Should not be able to create using non-interface class.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateWithNullParameter() {
        try {
            EventListenerSupport.create(null);
            EventListenerSupportTest.fail((String)"Should not be able to create using null class.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemoveListenerDuringEvent() throws PropertyVetoException {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        for (int i = 0; i < 10; ++i) {
            this.addDeregisterListener((EventListenerSupport<VetoableChangeListener>)listenerSupport);
        }
        EventListenerSupportTest.assertEquals((int)listenerSupport.getListenerCount(), (int)10);
        ((VetoableChangeListener)listenerSupport.fire()).vetoableChange(new PropertyChangeEvent(new Date(), "Day", 4, 5));
        EventListenerSupportTest.assertEquals((int)listenerSupport.getListenerCount(), (int)0);
    }

    public void testGetListeners() {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        VetoableChangeListener[] listeners = (VetoableChangeListener[])listenerSupport.getListeners();
        EventListenerSupportTest.assertEquals((int)0, (int)listeners.length);
        EventListenerSupportTest.assertEquals(VetoableChangeListener.class, listeners.getClass().getComponentType());
        VetoableChangeListener[] empty = listeners;
        EventListenerSupportTest.assertSame((Object)empty, (Object)listenerSupport.getListeners());
        VetoableChangeListener listener1 = (VetoableChangeListener)EasyMock.createNiceMock(VetoableChangeListener.class);
        listenerSupport.addListener((Object)listener1);
        EventListenerSupportTest.assertEquals((int)1, (int)((VetoableChangeListener[])listenerSupport.getListeners()).length);
        VetoableChangeListener listener2 = (VetoableChangeListener)EasyMock.createNiceMock(VetoableChangeListener.class);
        listenerSupport.addListener((Object)listener2);
        EventListenerSupportTest.assertEquals((int)2, (int)((VetoableChangeListener[])listenerSupport.getListeners()).length);
        listenerSupport.removeListener((Object)listener1);
        EventListenerSupportTest.assertEquals((int)1, (int)((VetoableChangeListener[])listenerSupport.getListeners()).length);
        listenerSupport.removeListener((Object)listener2);
        EventListenerSupportTest.assertSame((Object)empty, (Object)listenerSupport.getListeners());
    }

    public void testSerialization() throws IOException, ClassNotFoundException, PropertyVetoException {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        listenerSupport.addListener((Object)new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent e) {
            }
        });
        listenerSupport.addListener(EasyMock.createNiceMock(VetoableChangeListener.class));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(listenerSupport);
        objectOutputStream.close();
        EventListenerSupport deserializedListenerSupport = (EventListenerSupport)new ObjectInputStream(new ByteArrayInputStream(outputStream.toByteArray())).readObject();
        VetoableChangeListener[] listeners = (VetoableChangeListener[])deserializedListenerSupport.getListeners();
        EventListenerSupportTest.assertEquals(VetoableChangeListener.class, listeners.getClass().getComponentType());
        EventListenerSupportTest.assertEquals((int)1, (int)listeners.length);
        VetoableChangeListener listener = listeners[0];
        PropertyChangeEvent evt = new PropertyChangeEvent(new Date(), "Day", 7, 9);
        listener.vetoableChange(evt);
        EasyMock.replay((Object[])new Object[]{listener});
        ((VetoableChangeListener)deserializedListenerSupport.fire()).vetoableChange(evt);
        EasyMock.verify((Object[])new Object[]{listener});
        deserializedListenerSupport.removeListener((Object)listener);
        EventListenerSupportTest.assertEquals((int)0, (int)((VetoableChangeListener[])deserializedListenerSupport.getListeners()).length);
    }

    public void testSubclassInvocationHandling() throws PropertyVetoException {
        EventListenerSupport<VetoableChangeListener> eventListenerSupport = new EventListenerSupport<VetoableChangeListener>(VetoableChangeListener.class){

            protected InvocationHandler createInvocationHandler() {
                return new EventListenerSupport.ProxyInvocationHandler(){

                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        return "vetoableChange".equals(method.getName()) && "Hour".equals(((PropertyChangeEvent)args[0]).getPropertyName()) ? null : super.invoke(proxy, method, args);
                    }
                };
            }
        };
        VetoableChangeListener listener = (VetoableChangeListener)EasyMock.createNiceMock(VetoableChangeListener.class);
        eventListenerSupport.addListener((Object)listener);
        Date source = new Date();
        PropertyChangeEvent ignore = new PropertyChangeEvent(source, "Hour", 5, 6);
        PropertyChangeEvent respond = new PropertyChangeEvent(source, "Day", 6, 7);
        listener.vetoableChange(respond);
        EasyMock.replay((Object[])new Object[]{listener});
        ((VetoableChangeListener)eventListenerSupport.fire()).vetoableChange(ignore);
        ((VetoableChangeListener)eventListenerSupport.fire()).vetoableChange(respond);
        EasyMock.verify((Object[])new Object[]{listener});
    }

    private void addDeregisterListener(final EventListenerSupport<VetoableChangeListener> listenerSupport) {
        listenerSupport.addListener((Object)new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent e) {
                listenerSupport.removeListener((Object)this);
            }
        });
    }

    private VetoableChangeListener createListener(final List<VetoableChangeListener> calledListeners) {
        return new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent e) {
                calledListeners.add(this);
            }
        };
    }
}

