/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.builder.StandardToStringStyle;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringStyleTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StandardToStringStyleTest {
    private final Integer base = 5;
    private final String baseStr = "Integer";
    private static final StandardToStringStyle STYLE = new StandardToStringStyle();

    @Before
    public void setUp() throws Exception {
        ToStringBuilder.setDefaultStyle((ToStringStyle)STYLE);
    }

    @After
    public void tearDown() throws Exception {
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }

    @Test
    public void testBlank() {
        Assert.assertEquals((Object)"Integer[]", (Object)new ToStringBuilder((Object)this.base).toString());
    }

    @Test
    public void testAppendSuper() {
        Assert.assertEquals((Object)"Integer[]", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").toString());
        Assert.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[%NULL%]").toString());
        Assert.assertEquals((Object)"Integer[a=hello]", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").append("a", (Object)"hello").toString());
        Assert.assertEquals((Object)"Integer[%NULL%,a=hello]", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[%NULL%]").append("a", (Object)"hello").toString());
        Assert.assertEquals((Object)"Integer[a=hello]", (Object)new ToStringBuilder((Object)this.base).appendSuper(null).append("a", (Object)"hello").toString());
    }

    @Test
    public void testObject() {
        Integer i3 = 3;
        Integer i4 = 4;
        Assert.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append((Object)null).toString());
        Assert.assertEquals((Object)"Integer[3]", (Object)new ToStringBuilder((Object)this.base).append((Object)i3).toString());
        Assert.assertEquals((Object)"Integer[a=%NULL%]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)null).toString());
        Assert.assertEquals((Object)"Integer[a=3]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).toString());
        Assert.assertEquals((Object)"Integer[a=3,b=4]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).toString());
        Assert.assertEquals((Object)"Integer[a=%Integer%]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).toString());
        Assert.assertEquals((Object)"Integer[a=%SIZE=0%]", (Object)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), false).toString());
        Assert.assertEquals((Object)"Integer[a=[]]", (Object)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), true).toString());
        Assert.assertEquals((Object)"Integer[a=%SIZE=0%]", (Object)new ToStringBuilder((Object)this.base).append("a", new HashMap(), false).toString());
        Assert.assertEquals((Object)"Integer[a={}]", (Object)new ToStringBuilder((Object)this.base).append("a", new HashMap(), true).toString());
        Assert.assertEquals((Object)"Integer[a=%SIZE=0%]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], false).toString());
        Assert.assertEquals((Object)"Integer[a=[]]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], true).toString());
    }

    @Test
    public void testPerson() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person();
        p.name = "Suzy Queue";
        p.age = 19;
        p.smoker = false;
        String pBaseStr = "ToStringStyleTest.Person";
        Assert.assertEquals((Object)(pBaseStr + "[name=Suzy Queue,age=19,smoker=false]"), (Object)new ToStringBuilder((Object)p).append("name", (Object)p.name).append("age", p.age).append("smoker", p.smoker).toString());
    }

    @Test
    public void testLong() {
        Assert.assertEquals((Object)"Integer[3]", (Object)new ToStringBuilder((Object)this.base).append(3L).toString());
        Assert.assertEquals((Object)"Integer[a=3]", (Object)new ToStringBuilder((Object)this.base).append("a", 3L).toString());
        Assert.assertEquals((Object)"Integer[a=3,b=4]", (Object)new ToStringBuilder((Object)this.base).append("a", 3L).append("b", 4L).toString());
    }

    @Test
    public void testObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        Assert.assertEquals((Object)"Integer[[%NULL%, 5, [3, 6]]]", (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)"Integer[[%NULL%, 5, [3, 6]]]", (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assert.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        Assert.assertEquals((Object)"Integer[[1, 2, -3, 4]]", (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)"Integer[[1, 2, -3, 4]]", (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assert.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testLongArrayArray() {
        Object array = new long[][]{{1L, 2L}, null, {5L}};
        Assert.assertEquals((Object)"Integer[[[1, 2], %NULL%, [5]]]", (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)"Integer[[[1, 2], %NULL%, [5]]]", (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        Assert.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    static {
        STYLE.setUseShortClassName(true);
        STYLE.setUseIdentityHashCode(false);
        STYLE.setArrayStart("[");
        STYLE.setArraySeparator(", ");
        STYLE.setArrayEnd("]");
        STYLE.setNullText("%NULL%");
        STYLE.setSizeStartText("%SIZE=");
        STYLE.setSizeEndText("%");
        STYLE.setSummaryObjectStartText("%");
        STYLE.setSummaryObjectEndText("%");
    }
}

