/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.LinkedList;
import java.util.Random;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.junit.Ignore;
import org.junit.Test;

public class ReflectionToStringBuilderMutateInspectConcurrencyTest {
    @Test
    @Ignore
    public void testConcurrency() throws Exception {
        TestFixture testFixture = new TestFixture();
        int numMutators = 10;
        int numIterations = 10;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                Thread t = new Thread(new MutatingClient(testFixture));
                t.start();
                Thread s = new Thread(new InspectingClient(testFixture));
                s.start();
            }
        }
    }

    class InspectingClient
    implements Runnable {
        private final TestFixture testFixture;
        private final Random random = new Random();

        public InspectingClient(TestFixture testFixture) {
            this.testFixture = testFixture;
        }

        public void run() {
            ReflectionToStringBuilder.toString((Object)this.testFixture);
        }
    }

    class MutatingClient
    implements Runnable {
        private final TestFixture testFixture;
        private final Random random = new Random();

        public MutatingClient(TestFixture testFixture) {
            this.testFixture = testFixture;
        }

        public void run() {
            if (this.random.nextBoolean()) {
                this.testFixture.add();
            } else {
                this.testFixture.delete();
            }
        }
    }

    class TestFixture {
        private final LinkedList<Integer> listField = new LinkedList();
        private final Random random = new Random();
        private int N = 100;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TestFixture() {
            TestFixture testFixture = this;
            synchronized (testFixture) {
                for (int i = 0; i < this.N; ++i) {
                    this.listField.add(i);
                }
            }
        }

        public synchronized void add() {
            this.listField.add(this.random.nextInt(this.N));
        }

        public synchronized void delete() {
            this.listField.remove((Object)this.random.nextInt(this.N));
        }
    }
}

