/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Locale;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;

public class SystemUtilsTest
extends TestCase {
    public SystemUtilsTest(String name) {
        super(name);
    }

    public void testConstructor() {
        SystemUtilsTest.assertNotNull((Object)new SystemUtils());
        Constructor<?>[] cons = SystemUtils.class.getDeclaredConstructors();
        SystemUtilsTest.assertEquals((int)1, (int)cons.length);
        SystemUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        SystemUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(SystemUtils.class.getModifiers()));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(SystemUtils.class.getModifiers()));
    }

    public void testGetJavaHome() {
        File dir = SystemUtils.getJavaHome();
        Assert.assertNotNull((Object)dir);
        Assert.assertTrue((boolean)dir.exists());
    }

    public void testGetJavaIoTmpDir() {
        File dir = SystemUtils.getJavaIoTmpDir();
        Assert.assertNotNull((Object)dir);
        Assert.assertTrue((boolean)dir.exists());
    }

    public void testGetUserDir() {
        File dir = SystemUtils.getUserDir();
        Assert.assertNotNull((Object)dir);
        Assert.assertTrue((boolean)dir.exists());
    }

    public void testGetUserHome() {
        File dir = SystemUtils.getUserHome();
        Assert.assertNotNull((Object)dir);
        Assert.assertTrue((boolean)dir.exists());
    }

    public void testIS_JAVA() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion == null) {
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_1);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_2);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_3);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_4);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_5);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_6);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_7);
        } else if (javaVersion.startsWith("1.1")) {
            SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.IS_JAVA_1_1);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_2);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_3);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_4);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_5);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_6);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_7);
        } else if (javaVersion.startsWith("1.2")) {
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_1);
            SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.IS_JAVA_1_2);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_3);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_4);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_5);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_6);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_7);
        } else if (javaVersion.startsWith("1.3")) {
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_1);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_2);
            SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.IS_JAVA_1_3);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_4);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_5);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_6);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_7);
        } else if (javaVersion.startsWith("1.4")) {
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_1);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_2);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_3);
            SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.IS_JAVA_1_4);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_5);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_6);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_7);
        } else if (javaVersion.startsWith("1.5")) {
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_1);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_2);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_3);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_4);
            SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.IS_JAVA_1_5);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_6);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_7);
        } else if (javaVersion.startsWith("1.6")) {
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_1);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_2);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_3);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_4);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_5);
            SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.IS_JAVA_1_6);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_JAVA_1_7);
        } else {
            System.out.println("Can't test IS_JAVA value");
        }
    }

    public void testIS_OS() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_OS_WINDOWS);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_OS_UNIX);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_OS_SOLARIS);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_OS_LINUX);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_OS_MAC_OSX);
        } else if (osName.startsWith("Windows")) {
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_OS_UNIX);
            SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.IS_OS_WINDOWS);
        } else if (osName.startsWith("Solaris")) {
            SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.IS_OS_SOLARIS);
            SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.IS_OS_UNIX);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_OS_WINDOWS);
        } else if (osName.toLowerCase(Locale.ENGLISH).startsWith("linux")) {
            SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.IS_OS_LINUX);
            SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.IS_OS_UNIX);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_OS_WINDOWS);
        } else if (osName.startsWith("Mac OS X")) {
            SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.IS_OS_MAC_OSX);
            SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.IS_OS_UNIX);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_OS_WINDOWS);
        } else if (osName.startsWith("OS/2")) {
            SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.IS_OS_OS2);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_OS_UNIX);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_OS_WINDOWS);
        } else if (osName.startsWith("SunOS")) {
            SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.IS_OS_SUN_OS);
            SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.IS_OS_UNIX);
            SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.IS_OS_WINDOWS);
        } else {
            System.out.println("Can't test IS_OS value");
        }
    }

    public void testJavaVersionMatches() {
        String javaVersion = null;
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.0"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.1"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.2"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.3"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.4"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.5"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.6"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.7"));
        javaVersion = "";
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        javaVersion = "1.0";
        SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        javaVersion = "1.1";
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        javaVersion = "1.2";
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        javaVersion = "1.3.0";
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        javaVersion = "1.3.1";
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        javaVersion = "1.4.0";
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        javaVersion = "1.4.1";
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        javaVersion = "1.4.2";
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        javaVersion = "1.5.0";
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        javaVersion = "1.6.0";
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        javaVersion = "1.7.0";
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
    }

    public void testOSMatchesName() {
        String osName = null;
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isOSNameMatch(osName, (String)"Windows"));
        osName = "";
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isOSNameMatch((String)osName, (String)"Windows"));
        osName = "Windows 95";
        SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.isOSNameMatch((String)osName, (String)"Windows"));
        osName = "Windows NT";
        SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.isOSNameMatch((String)osName, (String)"Windows"));
        osName = "OS/2";
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isOSNameMatch((String)osName, (String)"Windows"));
    }

    public void testOSMatchesNameAndVersion() {
        String osName = null;
        String osVersion = null;
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isOSMatch(osName, osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "";
        osVersion = "";
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "Windows 95";
        osVersion = "4.0";
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "Windows 95";
        osVersion = "4.1";
        SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "Windows 98";
        osVersion = "4.1";
        SystemUtilsTest.assertEquals((boolean)true, (boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "Windows NT";
        osVersion = "4.0";
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "OS/2";
        osVersion = "4.0";
        SystemUtilsTest.assertEquals((boolean)false, (boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
    }

    public void testJavaAwtHeadless() {
        boolean atLeastJava14 = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4);
        String expectedStringValue = System.getProperty("java.awt.headless");
        String expectedStringValueWithDefault = System.getProperty("java.awt.headless", "false");
        SystemUtilsTest.assertNotNull((Object)expectedStringValueWithDefault);
        if (atLeastJava14) {
            boolean expectedValue = Boolean.valueOf(expectedStringValue);
            if (expectedStringValue != null) {
                SystemUtilsTest.assertEquals((String)expectedStringValue, (String)SystemUtils.JAVA_AWT_HEADLESS);
            }
            SystemUtilsTest.assertEquals((boolean)expectedValue, (boolean)SystemUtils.isJavaAwtHeadless());
        } else {
            SystemUtilsTest.assertNull((Object)expectedStringValue);
            SystemUtilsTest.assertNull((Object)SystemUtils.JAVA_AWT_HEADLESS);
            SystemUtilsTest.assertEquals((String)expectedStringValueWithDefault, (String)("" + SystemUtils.isJavaAwtHeadless()));
        }
        SystemUtilsTest.assertEquals((String)expectedStringValueWithDefault, (String)("" + SystemUtils.isJavaAwtHeadless()));
    }
}

