/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import junit.framework.TestCase;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.StringUtilsTest;

public class StringUtilsTrimEmptyTest
extends TestCase {
    private static final String FOO = "foo";

    public StringUtilsTrimEmptyTest(String name) {
        super(name);
    }

    public void testIsEmpty() {
        StringUtilsTrimEmptyTest.assertEquals((boolean)true, (boolean)StringUtils.isEmpty(null));
        StringUtilsTrimEmptyTest.assertEquals((boolean)true, (boolean)StringUtils.isEmpty((CharSequence)""));
        StringUtilsTrimEmptyTest.assertEquals((boolean)false, (boolean)StringUtils.isEmpty((CharSequence)" "));
        StringUtilsTrimEmptyTest.assertEquals((boolean)false, (boolean)StringUtils.isEmpty((CharSequence)FOO));
        StringUtilsTrimEmptyTest.assertEquals((boolean)false, (boolean)StringUtils.isEmpty((CharSequence)"  foo  "));
    }

    public void testIsNotEmpty() {
        StringUtilsTrimEmptyTest.assertEquals((boolean)false, (boolean)StringUtils.isNotEmpty(null));
        StringUtilsTrimEmptyTest.assertEquals((boolean)false, (boolean)StringUtils.isNotEmpty((CharSequence)""));
        StringUtilsTrimEmptyTest.assertEquals((boolean)true, (boolean)StringUtils.isNotEmpty((CharSequence)" "));
        StringUtilsTrimEmptyTest.assertEquals((boolean)true, (boolean)StringUtils.isNotEmpty((CharSequence)FOO));
        StringUtilsTrimEmptyTest.assertEquals((boolean)true, (boolean)StringUtils.isNotEmpty((CharSequence)"  foo  "));
    }

    public void testIsBlank() {
        StringUtilsTrimEmptyTest.assertEquals((boolean)true, (boolean)StringUtils.isBlank(null));
        StringUtilsTrimEmptyTest.assertEquals((boolean)true, (boolean)StringUtils.isBlank((CharSequence)""));
        StringUtilsTrimEmptyTest.assertEquals((boolean)true, (boolean)StringUtils.isBlank((CharSequence)StringUtilsTest.WHITESPACE));
        StringUtilsTrimEmptyTest.assertEquals((boolean)false, (boolean)StringUtils.isBlank((CharSequence)FOO));
        StringUtilsTrimEmptyTest.assertEquals((boolean)false, (boolean)StringUtils.isBlank((CharSequence)"  foo  "));
    }

    public void testIsNotBlank() {
        StringUtilsTrimEmptyTest.assertEquals((boolean)false, (boolean)StringUtils.isNotBlank(null));
        StringUtilsTrimEmptyTest.assertEquals((boolean)false, (boolean)StringUtils.isNotBlank((CharSequence)""));
        StringUtilsTrimEmptyTest.assertEquals((boolean)false, (boolean)StringUtils.isNotBlank((CharSequence)StringUtilsTest.WHITESPACE));
        StringUtilsTrimEmptyTest.assertEquals((boolean)true, (boolean)StringUtils.isNotBlank((CharSequence)FOO));
        StringUtilsTrimEmptyTest.assertEquals((boolean)true, (boolean)StringUtils.isNotBlank((CharSequence)"  foo  "));
    }

    public void testTrim() {
        StringUtilsTrimEmptyTest.assertEquals((String)FOO, (String)StringUtils.trim((String)"foo  "));
        StringUtilsTrimEmptyTest.assertEquals((String)FOO, (String)StringUtils.trim((String)" foo  "));
        StringUtilsTrimEmptyTest.assertEquals((String)FOO, (String)StringUtils.trim((String)" foo"));
        StringUtilsTrimEmptyTest.assertEquals((String)FOO, (String)StringUtils.trim((String)FOO));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.trim((String)" \t\r\n\b "));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.trim((String)StringUtilsTest.TRIMMABLE));
        StringUtilsTrimEmptyTest.assertEquals((String)StringUtilsTest.NON_TRIMMABLE, (String)StringUtils.trim((String)StringUtilsTest.NON_TRIMMABLE));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.trim((String)""));
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.trim(null));
    }

    public void testTrimToNull() {
        StringUtilsTrimEmptyTest.assertEquals((String)FOO, (String)StringUtils.trimToNull((String)"foo  "));
        StringUtilsTrimEmptyTest.assertEquals((String)FOO, (String)StringUtils.trimToNull((String)" foo  "));
        StringUtilsTrimEmptyTest.assertEquals((String)FOO, (String)StringUtils.trimToNull((String)" foo"));
        StringUtilsTrimEmptyTest.assertEquals((String)FOO, (String)StringUtils.trimToNull((String)FOO));
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.trimToNull((String)" \t\r\n\b "));
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.trimToNull((String)StringUtilsTest.TRIMMABLE));
        StringUtilsTrimEmptyTest.assertEquals((String)StringUtilsTest.NON_TRIMMABLE, (String)StringUtils.trimToNull((String)StringUtilsTest.NON_TRIMMABLE));
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.trimToNull((String)""));
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.trimToNull(null));
    }

    public void testTrimToEmpty() {
        StringUtilsTrimEmptyTest.assertEquals((String)FOO, (String)StringUtils.trimToEmpty((String)"foo  "));
        StringUtilsTrimEmptyTest.assertEquals((String)FOO, (String)StringUtils.trimToEmpty((String)" foo  "));
        StringUtilsTrimEmptyTest.assertEquals((String)FOO, (String)StringUtils.trimToEmpty((String)" foo"));
        StringUtilsTrimEmptyTest.assertEquals((String)FOO, (String)StringUtils.trimToEmpty((String)FOO));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.trimToEmpty((String)" \t\r\n\b "));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.trimToEmpty((String)StringUtilsTest.TRIMMABLE));
        StringUtilsTrimEmptyTest.assertEquals((String)StringUtilsTest.NON_TRIMMABLE, (String)StringUtils.trimToEmpty((String)StringUtilsTest.NON_TRIMMABLE));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.trimToEmpty((String)""));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.trimToEmpty(null));
    }

    public void testStrip_String() {
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.strip(null));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.strip((String)""));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.strip((String)"        "));
        StringUtilsTrimEmptyTest.assertEquals((String)"abc", (String)StringUtils.strip((String)"  abc  "));
        StringUtilsTrimEmptyTest.assertEquals((String)StringUtilsTest.NON_WHITESPACE, (String)StringUtils.strip((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE)));
    }

    public void testStripToNull_String() {
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.stripToNull(null));
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.stripToNull((String)""));
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.stripToNull((String)"        "));
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.stripToNull((String)StringUtilsTest.WHITESPACE));
        StringUtilsTrimEmptyTest.assertEquals((String)"ab c", (String)StringUtils.stripToNull((String)"  ab c  "));
        StringUtilsTrimEmptyTest.assertEquals((String)StringUtilsTest.NON_WHITESPACE, (String)StringUtils.stripToNull((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE)));
    }

    public void testStripToEmpty_String() {
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.stripToEmpty(null));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.stripToEmpty((String)""));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.stripToEmpty((String)"        "));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.stripToEmpty((String)StringUtilsTest.WHITESPACE));
        StringUtilsTrimEmptyTest.assertEquals((String)"ab c", (String)StringUtils.stripToEmpty((String)"  ab c  "));
        StringUtilsTrimEmptyTest.assertEquals((String)StringUtilsTest.NON_WHITESPACE, (String)StringUtils.stripToEmpty((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE)));
    }

    public void testStrip_StringString() {
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.strip(null, null));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.strip((String)"", null));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.strip((String)"        ", null));
        StringUtilsTrimEmptyTest.assertEquals((String)"abc", (String)StringUtils.strip((String)"  abc  ", null));
        StringUtilsTrimEmptyTest.assertEquals((String)StringUtilsTest.NON_WHITESPACE, (String)StringUtils.strip((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE), null));
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.strip(null, (String)""));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.strip((String)"", (String)""));
        StringUtilsTrimEmptyTest.assertEquals((String)"        ", (String)StringUtils.strip((String)"        ", (String)""));
        StringUtilsTrimEmptyTest.assertEquals((String)"  abc  ", (String)StringUtils.strip((String)"  abc  ", (String)""));
        StringUtilsTrimEmptyTest.assertEquals((String)StringUtilsTest.WHITESPACE, (String)StringUtils.strip((String)StringUtilsTest.WHITESPACE, (String)""));
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.strip(null, (String)" "));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.strip((String)"", (String)" "));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.strip((String)"        ", (String)" "));
        StringUtilsTrimEmptyTest.assertEquals((String)"abc", (String)StringUtils.strip((String)"  abc  ", (String)" "));
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.strip(null, (String)"ab"));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.strip((String)"", (String)"ab"));
        StringUtilsTrimEmptyTest.assertEquals((String)"        ", (String)StringUtils.strip((String)"        ", (String)"ab"));
        StringUtilsTrimEmptyTest.assertEquals((String)"  abc  ", (String)StringUtils.strip((String)"  abc  ", (String)"ab"));
        StringUtilsTrimEmptyTest.assertEquals((String)"c", (String)StringUtils.strip((String)"abcabab", (String)"ab"));
        StringUtilsTrimEmptyTest.assertEquals((String)StringUtilsTest.WHITESPACE, (String)StringUtils.strip((String)StringUtilsTest.WHITESPACE, (String)""));
    }

    public void testStripStart_StringString() {
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.stripStart(null, null));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.stripStart((String)"", null));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.stripStart((String)"        ", null));
        StringUtilsTrimEmptyTest.assertEquals((String)"abc  ", (String)StringUtils.stripStart((String)"  abc  ", null));
        StringUtilsTrimEmptyTest.assertEquals((String)(StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE), (String)StringUtils.stripStart((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE), null));
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.stripStart(null, (String)""));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.stripStart((String)"", (String)""));
        StringUtilsTrimEmptyTest.assertEquals((String)"        ", (String)StringUtils.stripStart((String)"        ", (String)""));
        StringUtilsTrimEmptyTest.assertEquals((String)"  abc  ", (String)StringUtils.stripStart((String)"  abc  ", (String)""));
        StringUtilsTrimEmptyTest.assertEquals((String)StringUtilsTest.WHITESPACE, (String)StringUtils.stripStart((String)StringUtilsTest.WHITESPACE, (String)""));
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.stripStart(null, (String)" "));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.stripStart((String)"", (String)" "));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.stripStart((String)"        ", (String)" "));
        StringUtilsTrimEmptyTest.assertEquals((String)"abc  ", (String)StringUtils.stripStart((String)"  abc  ", (String)" "));
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.stripStart(null, (String)"ab"));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.stripStart((String)"", (String)"ab"));
        StringUtilsTrimEmptyTest.assertEquals((String)"        ", (String)StringUtils.stripStart((String)"        ", (String)"ab"));
        StringUtilsTrimEmptyTest.assertEquals((String)"  abc  ", (String)StringUtils.stripStart((String)"  abc  ", (String)"ab"));
        StringUtilsTrimEmptyTest.assertEquals((String)"cabab", (String)StringUtils.stripStart((String)"abcabab", (String)"ab"));
        StringUtilsTrimEmptyTest.assertEquals((String)StringUtilsTest.WHITESPACE, (String)StringUtils.stripStart((String)StringUtilsTest.WHITESPACE, (String)""));
    }

    public void testStripEnd_StringString() {
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.stripEnd(null, null));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.stripEnd((String)"", null));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.stripEnd((String)"        ", null));
        StringUtilsTrimEmptyTest.assertEquals((String)"  abc", (String)StringUtils.stripEnd((String)"  abc  ", null));
        StringUtilsTrimEmptyTest.assertEquals((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE), (String)StringUtils.stripEnd((String)(StringUtilsTest.WHITESPACE + StringUtilsTest.NON_WHITESPACE + StringUtilsTest.WHITESPACE), null));
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.stripEnd(null, (String)""));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.stripEnd((String)"", (String)""));
        StringUtilsTrimEmptyTest.assertEquals((String)"        ", (String)StringUtils.stripEnd((String)"        ", (String)""));
        StringUtilsTrimEmptyTest.assertEquals((String)"  abc  ", (String)StringUtils.stripEnd((String)"  abc  ", (String)""));
        StringUtilsTrimEmptyTest.assertEquals((String)StringUtilsTest.WHITESPACE, (String)StringUtils.stripEnd((String)StringUtilsTest.WHITESPACE, (String)""));
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.stripEnd(null, (String)" "));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.stripEnd((String)"", (String)" "));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.stripEnd((String)"        ", (String)" "));
        StringUtilsTrimEmptyTest.assertEquals((String)"  abc", (String)StringUtils.stripEnd((String)"  abc  ", (String)" "));
        StringUtilsTrimEmptyTest.assertEquals(null, (String)StringUtils.stripEnd(null, (String)"ab"));
        StringUtilsTrimEmptyTest.assertEquals((String)"", (String)StringUtils.stripEnd((String)"", (String)"ab"));
        StringUtilsTrimEmptyTest.assertEquals((String)"        ", (String)StringUtils.stripEnd((String)"        ", (String)"ab"));
        StringUtilsTrimEmptyTest.assertEquals((String)"  abc  ", (String)StringUtils.stripEnd((String)"  abc  ", (String)"ab"));
        StringUtilsTrimEmptyTest.assertEquals((String)"abc", (String)StringUtils.stripEnd((String)"abcabab", (String)"ab"));
        StringUtilsTrimEmptyTest.assertEquals((String)StringUtilsTest.WHITESPACE, (String)StringUtils.stripEnd((String)StringUtilsTest.WHITESPACE, (String)""));
    }

    public void testStripAll() {
        Object[] empty = new String[]{};
        String[] fooSpace = new String[]{"  foo  ", "  foo", "foo  "};
        String[] fooDots = new String[]{"..foo..", "..foo", "foo.."};
        Object[] foo = new String[]{FOO, FOO, FOO};
        StringUtilsTrimEmptyTest.assertEquals(null, (Object)StringUtils.stripAll((String[])null));
        this.assertArrayEquals(empty, StringUtils.stripAll((String[])new String[0]));
        this.assertArrayEquals(new String[]{null}, StringUtils.stripAll((String[])new String[]{null}));
        this.assertArrayEquals(empty, StringUtils.stripAll((String[])empty));
        this.assertArrayEquals(foo, StringUtils.stripAll((String[])fooSpace));
        StringUtilsTrimEmptyTest.assertEquals(null, (Object)StringUtils.stripAll(null, null));
        this.assertArrayEquals(foo, StringUtils.stripAll((String[])fooSpace, null));
        this.assertArrayEquals(foo, StringUtils.stripAll((String[])fooDots, (String)"."));
    }

    public void testStripAccents() {
        String cue = "\u00c7\u00fa\u00ea";
        StringUtilsTrimEmptyTest.assertEquals((String)("Failed to strip accents from " + cue), (String)"Cue", (String)StringUtils.stripAccents((String)cue));
        String lots = "\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d9\u00da\u00db\u00dc\u00dd";
        StringUtilsTrimEmptyTest.assertEquals((String)("Failed to strip accents from " + lots), (String)"AAAAAACEEEEIIIINOOOOOUUUUY", (String)StringUtils.stripAccents((String)lots));
        StringUtilsTrimEmptyTest.assertNull((String)"Failed null safety", (Object)StringUtils.stripAccents(null));
        StringUtilsTrimEmptyTest.assertEquals((String)"Failed empty String", (String)"", (String)StringUtils.stripAccents((String)""));
        StringUtilsTrimEmptyTest.assertEquals((String)"Failed to handle non-accented text", (String)"control", (String)StringUtils.stripAccents((String)"control"));
        StringUtilsTrimEmptyTest.assertEquals((String)"Failed to handle easy example", (String)"eclair", (String)StringUtils.stripAccents((String)"\u00e9clair"));
    }

    private void assertArrayEquals(Object[] o1, Object[] o2) {
        if (o1 == null) {
            StringUtilsTrimEmptyTest.assertEquals((Object)o1, (Object)o2);
            return;
        }
        StringUtilsTrimEmptyTest.assertEquals((String)"Length not equal. ", (int)o1.length, (int)o2.length);
        int sz = o1.length;
        for (int i = 0; i < sz; ++i) {
            if (o1[i] instanceof Object[]) {
                this.assertArrayEquals((Object[])o1[i], (Object[])o2[i]);
                continue;
            }
            StringUtilsTrimEmptyTest.assertEquals((Object)o1[i], (Object)o2[i]);
        }
    }
}

