/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Comparator;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RangeTest {
    private Range<Byte> byteRange;
    private Range<Byte> byteRange2;
    private Range<Byte> byteRange3;
    private Range<Integer> intRange;
    private Range<Long> longRange;
    private Range<Float> floatRange;
    private Range<Double> doubleRange;

    @Before
    public void setUp() {
        this.byteRange = Range.between((Comparable)Byte.valueOf((byte)0), (Comparable)Byte.valueOf((byte)5));
        this.byteRange2 = Range.between((Comparable)Byte.valueOf((byte)0), (Comparable)Byte.valueOf((byte)5));
        this.byteRange3 = Range.between((Comparable)Byte.valueOf((byte)0), (Comparable)Byte.valueOf((byte)10));
        this.intRange = Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20));
        this.longRange = Range.between((Comparable)Long.valueOf(10L), (Comparable)Long.valueOf(20L));
        this.floatRange = Range.between((Comparable)Float.valueOf(10.0f), (Comparable)Float.valueOf(20.0f));
        this.doubleRange = Range.between((Comparable)Double.valueOf(10.0), (Comparable)Double.valueOf(20.0));
    }

    @Test
    public void testComparableConstructors() {
        Comparable c = new Comparable(){

            public int compareTo(Object other) {
                return 1;
            }
        };
        Range r1 = Range.is((Comparable)c);
        Range r2 = Range.between((Comparable)c, (Comparable)c);
        Assert.assertEquals((Object)true, (Object)r1.isNaturalOrdering());
        Assert.assertEquals((Object)true, (Object)r2.isNaturalOrdering());
    }

    @Test
    public void testIsWithCompare() {
        Comparator<Integer> c = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return 0;
            }
        };
        Range ri = Range.is((Comparable)Integer.valueOf(10));
        Assert.assertFalse((String)"should not contain null", (boolean)ri.contains(null));
        Assert.assertTrue((String)"should contain 10", (boolean)ri.contains((Object)10));
        Assert.assertFalse((String)"should not contain 11", (boolean)ri.contains((Object)11));
        ri = Range.is((Object)10, (Comparator)c);
        Assert.assertFalse((String)"should not contain null", (boolean)ri.contains(null));
        Assert.assertTrue((String)"should contain 10", (boolean)ri.contains((Object)10));
        Assert.assertTrue((String)"should contain 11", (boolean)ri.contains((Object)11));
    }

    @Test
    public void testBetweenWithCompare() {
        Comparator<Integer> c = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return 0;
            }
        };
        Range rb = Range.between((Comparable)Integer.valueOf(-10), (Comparable)Integer.valueOf(20));
        Assert.assertFalse((String)"should not contain null", (boolean)rb.contains(null));
        Assert.assertTrue((String)"should contain 10", (boolean)rb.contains((Object)10));
        Assert.assertTrue((String)"should contain -10", (boolean)rb.contains((Object)-10));
        Assert.assertFalse((String)"should not contain 21", (boolean)rb.contains((Object)21));
        Assert.assertFalse((String)"should not contain -11", (boolean)rb.contains((Object)-11));
        rb = Range.between((Object)-10, (Object)20, (Comparator)c);
        Assert.assertFalse((String)"should not contain null", (boolean)rb.contains(null));
        Assert.assertTrue((String)"should contain 10", (boolean)rb.contains((Object)10));
        Assert.assertTrue((String)"should contain -10", (boolean)rb.contains((Object)-10));
        Assert.assertTrue((String)"should contain 21", (boolean)rb.contains((Object)21));
        Assert.assertTrue((String)"should contain -11", (boolean)rb.contains((Object)-11));
    }

    @Test
    public void testRangeOfChars() {
        Range chars = Range.between((Comparable)Character.valueOf('a'), (Comparable)Character.valueOf('z'));
        Assert.assertTrue((boolean)chars.contains((Object)Character.valueOf('b')));
        Assert.assertFalse((boolean)chars.contains((Object)Character.valueOf('B')));
    }

    @Test
    public void testEqualsObject() {
        Assert.assertEquals(this.byteRange, this.byteRange);
        Assert.assertEquals(this.byteRange, this.byteRange2);
        Assert.assertEquals(this.byteRange2, this.byteRange2);
        Assert.assertTrue((boolean)this.byteRange.equals(this.byteRange));
        Assert.assertTrue((boolean)this.byteRange2.equals(this.byteRange2));
        Assert.assertTrue((boolean)this.byteRange3.equals(this.byteRange3));
        Assert.assertFalse((boolean)this.byteRange2.equals(this.byteRange3));
        Assert.assertFalse((boolean)this.byteRange2.equals(null));
        Assert.assertFalse((boolean)this.byteRange2.equals((Object)"Ni!"));
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)this.byteRange.hashCode(), (long)this.byteRange2.hashCode());
        Assert.assertFalse((this.byteRange.hashCode() == this.byteRange3.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((long)this.intRange.hashCode(), (long)this.intRange.hashCode());
        Assert.assertTrue((this.intRange.hashCode() != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        Assert.assertNotNull((Object)this.byteRange.toString());
        String str = this.intRange.toString();
        Assert.assertEquals((Object)"[10..20]", (Object)str);
        Assert.assertEquals((Object)"[-20..-10]", (Object)Range.between((Comparable)Integer.valueOf(-20), (Comparable)Integer.valueOf(-10)).toString());
    }

    @Test
    public void testToStringFormat() {
        String str = this.intRange.toString("From %1$s to %2$s");
        Assert.assertEquals((Object)"From 10 to 20", (Object)str);
    }

    @Test
    public void testGetMinimum() {
        Assert.assertEquals((long)10L, (long)((Integer)this.intRange.getMinimum()).intValue());
        Assert.assertEquals((long)10L, (long)((Long)this.longRange.getMinimum()));
        Assert.assertEquals((double)10.0, (double)((Float)this.floatRange.getMinimum()).floatValue(), (double)1.0E-5f);
        Assert.assertEquals((double)10.0, (double)((Double)this.doubleRange.getMinimum()), (double)1.0E-5);
    }

    @Test
    public void testGetMaximum() {
        Assert.assertEquals((long)20L, (long)((Integer)this.intRange.getMaximum()).intValue());
        Assert.assertEquals((long)20L, (long)((Long)this.longRange.getMaximum()));
        Assert.assertEquals((double)20.0, (double)((Float)this.floatRange.getMaximum()).floatValue(), (double)1.0E-5f);
        Assert.assertEquals((double)20.0, (double)((Double)this.doubleRange.getMaximum()), (double)1.0E-5);
    }

    @Test
    public void testContains() {
        Assert.assertFalse((boolean)this.intRange.contains(null));
        Assert.assertFalse((boolean)this.intRange.contains((Object)5));
        Assert.assertTrue((boolean)this.intRange.contains((Object)10));
        Assert.assertTrue((boolean)this.intRange.contains((Object)15));
        Assert.assertTrue((boolean)this.intRange.contains((Object)20));
        Assert.assertFalse((boolean)this.intRange.contains((Object)25));
    }

    @Test
    public void testIsAfter() {
        Assert.assertFalse((boolean)this.intRange.isAfter(null));
        Assert.assertTrue((boolean)this.intRange.isAfter((Object)5));
        Assert.assertFalse((boolean)this.intRange.isAfter((Object)10));
        Assert.assertFalse((boolean)this.intRange.isAfter((Object)15));
        Assert.assertFalse((boolean)this.intRange.isAfter((Object)20));
        Assert.assertFalse((boolean)this.intRange.isAfter((Object)25));
    }

    @Test
    public void testIsStartedBy() {
        Assert.assertFalse((boolean)this.intRange.isStartedBy(null));
        Assert.assertFalse((boolean)this.intRange.isStartedBy((Object)5));
        Assert.assertTrue((boolean)this.intRange.isStartedBy((Object)10));
        Assert.assertFalse((boolean)this.intRange.isStartedBy((Object)15));
        Assert.assertFalse((boolean)this.intRange.isStartedBy((Object)20));
        Assert.assertFalse((boolean)this.intRange.isStartedBy((Object)25));
    }

    @Test
    public void testIsEndedBy() {
        Assert.assertFalse((boolean)this.intRange.isEndedBy(null));
        Assert.assertFalse((boolean)this.intRange.isEndedBy((Object)5));
        Assert.assertFalse((boolean)this.intRange.isEndedBy((Object)10));
        Assert.assertFalse((boolean)this.intRange.isEndedBy((Object)15));
        Assert.assertTrue((boolean)this.intRange.isEndedBy((Object)20));
        Assert.assertFalse((boolean)this.intRange.isEndedBy((Object)25));
    }

    @Test
    public void testIsBefore() {
        Assert.assertFalse((boolean)this.intRange.isBefore(null));
        Assert.assertFalse((boolean)this.intRange.isBefore((Object)5));
        Assert.assertFalse((boolean)this.intRange.isBefore((Object)10));
        Assert.assertFalse((boolean)this.intRange.isBefore((Object)15));
        Assert.assertFalse((boolean)this.intRange.isBefore((Object)20));
        Assert.assertTrue((boolean)this.intRange.isBefore((Object)25));
    }

    @Test
    public void testElementCompareTo() {
        try {
            this.intRange.elementCompareTo(null);
            Assert.fail((String)"NullPointerException should have been thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.intRange.elementCompareTo((Object)5));
        Assert.assertEquals((long)0L, (long)this.intRange.elementCompareTo((Object)10));
        Assert.assertEquals((long)0L, (long)this.intRange.elementCompareTo((Object)15));
        Assert.assertEquals((long)0L, (long)this.intRange.elementCompareTo((Object)20));
        Assert.assertEquals((long)1L, (long)this.intRange.elementCompareTo((Object)25));
    }

    @Test
    public void testContainsRange() {
        Assert.assertFalse((boolean)this.intRange.containsRange(null));
        Assert.assertTrue((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(18))));
        Assert.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(32), (Comparable)Integer.valueOf(45))));
        Assert.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(8))));
        Assert.assertTrue((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20))));
        Assert.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(14))));
        Assert.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(16), (Comparable)Integer.valueOf(21))));
        Assert.assertTrue((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(19))));
        Assert.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(21))));
        Assert.assertTrue((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(11), (Comparable)Integer.valueOf(20))));
        Assert.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(20))));
        Assert.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(-11), (Comparable)Integer.valueOf(-18))));
    }

    @Test
    public void testIsAfterRange() {
        Assert.assertFalse((boolean)this.intRange.isAfterRange(null));
        Assert.assertTrue((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(9))));
        Assert.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(10))));
        Assert.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(20))));
        Assert.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(25))));
        Assert.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(25))));
        Assert.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(21), (Comparable)Integer.valueOf(25))));
        Assert.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20))));
    }

    @Test
    public void testIsOverlappedBy() {
        Assert.assertFalse((boolean)this.intRange.isOverlappedBy(null));
        Assert.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(18))));
        Assert.assertFalse((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(32), (Comparable)Integer.valueOf(45))));
        Assert.assertFalse((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(8))));
        Assert.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20))));
        Assert.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(14))));
        Assert.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(16), (Comparable)Integer.valueOf(21))));
        Assert.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(19))));
        Assert.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(21))));
        Assert.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(11), (Comparable)Integer.valueOf(20))));
        Assert.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(20))));
        Assert.assertFalse((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(-11), (Comparable)Integer.valueOf(-18))));
    }

    @Test
    public void testIsBeforeRange() {
        Assert.assertFalse((boolean)this.intRange.isBeforeRange(null));
        Assert.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(9))));
        Assert.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(10))));
        Assert.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(20))));
        Assert.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(25))));
        Assert.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(25))));
        Assert.assertTrue((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(21), (Comparable)Integer.valueOf(25))));
        Assert.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20))));
    }

    @Test
    public void testIntersectionWith() {
        Assert.assertSame(this.intRange, (Object)this.intRange.intersectionWith(this.intRange));
        Assert.assertSame(this.byteRange, (Object)this.byteRange.intersectionWith(this.byteRange));
        Assert.assertSame(this.longRange, (Object)this.longRange.intersectionWith(this.longRange));
        Assert.assertSame(this.floatRange, (Object)this.floatRange.intersectionWith(this.floatRange));
        Assert.assertSame(this.doubleRange, (Object)this.doubleRange.intersectionWith(this.doubleRange));
        Assert.assertEquals((Object)Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15)), (Object)this.intRange.intersectionWith(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(15))));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIntersectionWithNull() {
        this.intRange.intersectionWith(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIntersectionWithNonOverlapping() {
        this.intRange.intersectionWith(Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(9)));
    }

    @Test
    public void testSerializing() {
        SerializationUtils.clone(this.intRange);
    }
}

