/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.lang3.RandomStringUtils;

public class RandomStringUtilsTest
extends TestCase {
    public RandomStringUtilsTest(String name) {
        super(name);
    }

    public void testConstructor() {
        RandomStringUtilsTest.assertNotNull((Object)new RandomStringUtils());
        Constructor<?>[] cons = RandomStringUtils.class.getDeclaredConstructors();
        RandomStringUtilsTest.assertEquals((int)1, (int)cons.length);
        RandomStringUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        RandomStringUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(RandomStringUtils.class.getModifiers()));
        RandomStringUtilsTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(RandomStringUtils.class.getModifiers()));
    }

    public void testRandomStringUtils() {
        int i;
        int i2;
        String r1 = RandomStringUtils.random((int)50);
        RandomStringUtilsTest.assertEquals((String)"random(50) length", (int)50, (int)r1.length());
        String r2 = RandomStringUtils.random((int)50);
        RandomStringUtilsTest.assertEquals((String)"random(50) length", (int)50, (int)r2.length());
        RandomStringUtilsTest.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        r1 = RandomStringUtils.randomAscii((int)50);
        RandomStringUtilsTest.assertEquals((String)"randomAscii(50) length", (int)50, (int)r1.length());
        for (i2 = 0; i2 < r1.length(); ++i2) {
            RandomStringUtilsTest.assertTrue((String)"char between 32 and 127", (r1.charAt(i2) >= ' ' && r1.charAt(i2) <= '\u007f' ? 1 : 0) != 0);
        }
        r2 = RandomStringUtils.randomAscii((int)50);
        RandomStringUtilsTest.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        r1 = RandomStringUtils.randomAlphabetic((int)50);
        RandomStringUtilsTest.assertEquals((String)"randomAlphabetic(50)", (int)50, (int)r1.length());
        for (i2 = 0; i2 < r1.length(); ++i2) {
            RandomStringUtilsTest.assertEquals((String)"r1 contains alphabetic", (boolean)true, (Character.isLetter(r1.charAt(i2)) && !Character.isDigit(r1.charAt(i2)) ? 1 : 0) != 0);
        }
        r2 = RandomStringUtils.randomAlphabetic((int)50);
        RandomStringUtilsTest.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        r1 = RandomStringUtils.randomAlphanumeric((int)50);
        RandomStringUtilsTest.assertEquals((String)"randomAlphanumeric(50)", (int)50, (int)r1.length());
        for (i2 = 0; i2 < r1.length(); ++i2) {
            RandomStringUtilsTest.assertEquals((String)"r1 contains alphanumeric", (boolean)true, (boolean)Character.isLetterOrDigit(r1.charAt(i2)));
        }
        r2 = RandomStringUtils.randomAlphabetic((int)50);
        RandomStringUtilsTest.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        r1 = RandomStringUtils.randomNumeric((int)50);
        RandomStringUtilsTest.assertEquals((String)"randomNumeric(50)", (int)50, (int)r1.length());
        for (i2 = 0; i2 < r1.length(); ++i2) {
            RandomStringUtilsTest.assertEquals((String)"r1 contains numeric", (boolean)true, (Character.isDigit(r1.charAt(i2)) && !Character.isLetter(r1.charAt(i2)) ? 1 : 0) != 0);
        }
        r2 = RandomStringUtils.randomNumeric((int)50);
        RandomStringUtilsTest.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        String set = "abcdefg";
        r1 = RandomStringUtils.random((int)50, (String)set);
        RandomStringUtilsTest.assertEquals((String)"random(50, \"abcdefg\")", (int)50, (int)r1.length());
        for (i = 0; i < r1.length(); ++i) {
            RandomStringUtilsTest.assertTrue((String)"random char in set", (set.indexOf(r1.charAt(i)) > -1 ? 1 : 0) != 0);
        }
        r2 = RandomStringUtils.random((int)50, (String)set);
        RandomStringUtilsTest.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        r1 = RandomStringUtils.random((int)50, (String)null);
        RandomStringUtilsTest.assertEquals((String)"random(50) length", (int)50, (int)r1.length());
        r2 = RandomStringUtils.random((int)50, (String)null);
        RandomStringUtilsTest.assertEquals((String)"random(50) length", (int)50, (int)r2.length());
        RandomStringUtilsTest.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        set = "stuvwxyz";
        r1 = RandomStringUtils.random((int)50, (char[])set.toCharArray());
        RandomStringUtilsTest.assertEquals((String)"random(50, \"stuvwxyz\")", (int)50, (int)r1.length());
        for (i = 0; i < r1.length(); ++i) {
            RandomStringUtilsTest.assertTrue((String)"random char in set", (set.indexOf(r1.charAt(i)) > -1 ? 1 : 0) != 0);
        }
        r2 = RandomStringUtils.random((int)50, (String)set);
        RandomStringUtilsTest.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        r1 = RandomStringUtils.random((int)50, (char[])null);
        RandomStringUtilsTest.assertEquals((String)"random(50) length", (int)50, (int)r1.length());
        r2 = RandomStringUtils.random((int)50, (char[])null);
        RandomStringUtilsTest.assertEquals((String)"random(50) length", (int)50, (int)r2.length());
        RandomStringUtilsTest.assertTrue((String)"!r1.equals(r2)", (!r1.equals(r2) ? 1 : 0) != 0);
        long seed = System.currentTimeMillis();
        r1 = RandomStringUtils.random((int)50, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new Random(seed));
        r2 = RandomStringUtils.random((int)50, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new Random(seed));
        RandomStringUtilsTest.assertEquals((String)"r1.equals(r2)", (String)r1, (String)r2);
        r1 = RandomStringUtils.random((int)0);
        RandomStringUtilsTest.assertEquals((String)"random(0).equals(\"\")", (String)"", (String)r1);
    }

    public void testExceptions() {
        try {
            RandomStringUtils.random((int)-1);
            RandomStringUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            RandomStringUtils.random((int)-1, (boolean)true, (boolean)true);
            RandomStringUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            RandomStringUtils.random((int)-1, (char[])new char[0]);
            RandomStringUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            RandomStringUtils.random((int)-1, (String)"");
            RandomStringUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            RandomStringUtils.random((int)-1, (int)97, (int)122, (boolean)false, (boolean)false);
            RandomStringUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            RandomStringUtils.random((int)-1, (int)97, (int)122, (boolean)false, (boolean)false, (char[])new char[0]);
            RandomStringUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            RandomStringUtils.random((int)-1, (int)97, (int)122, (boolean)false, (boolean)false, (char[])new char[0], (Random)new Random());
            RandomStringUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRandomAlphaNumeric() {
        int i;
        char[] testChars = new char[]{'a', 'z', 'A', 'Z', '0', '9'};
        boolean[] found = new boolean[]{false, false, false, false, false, false};
        for (i = 0; i < 100; ++i) {
            String randString = RandomStringUtils.randomAlphanumeric((int)10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            if (found[i]) continue;
            RandomStringUtilsTest.fail((String)("alphanumeric character not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem "));
        }
    }

    public void testRandomNumeric() {
        int i;
        char[] testChars = new char[]{'0', '9'};
        boolean[] found = new boolean[]{false, false};
        for (i = 0; i < 100; ++i) {
            String randString = RandomStringUtils.randomNumeric((int)10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            if (found[i]) continue;
            RandomStringUtilsTest.fail((String)("digit not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem "));
        }
    }

    public void testRandomAlphabetic() {
        int i;
        char[] testChars = new char[]{'a', 'z', 'A', 'Z'};
        boolean[] found = new boolean[]{false, false, false, false};
        for (i = 0; i < 100; ++i) {
            String randString = RandomStringUtils.randomAlphabetic((int)10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            if (found[i]) continue;
            RandomStringUtilsTest.fail((String)("alphanumeric character not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem "));
        }
    }

    public void testRandomAscii() {
        int i;
        char[] testChars = new char[]{' ', '~'};
        boolean[] found = new boolean[]{false, false};
        for (i = 0; i < 100; ++i) {
            String randString = RandomStringUtils.randomAscii((int)10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            if (found[i]) continue;
            RandomStringUtilsTest.fail((String)("ascii character not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem"));
        }
    }

    public void testRandomStringUtilsHomog() {
        String set = "abc";
        char[] chars = set.toCharArray();
        String gen = "";
        int[] counts = new int[]{0, 0, 0};
        int[] expected = new int[]{200, 200, 200};
        for (int i = 0; i < 100; ++i) {
            gen = RandomStringUtils.random((int)6, (char[])chars);
            block6: for (int j = 0; j < 6; ++j) {
                switch (gen.charAt(j)) {
                    case 'a': {
                        counts[0] = counts[0] + 1;
                        continue block6;
                    }
                    case 'b': {
                        counts[1] = counts[1] + 1;
                        continue block6;
                    }
                    case 'c': {
                        counts[2] = counts[2] + 1;
                        continue block6;
                    }
                    default: {
                        RandomStringUtilsTest.fail((String)"generated character not in set");
                    }
                }
            }
        }
        RandomStringUtilsTest.assertTrue((String)"test homogeneity -- will fail about 1 in 1000 times", (this.chiSquare(expected, counts) < 13.82 ? 1 : 0) != 0);
    }

    private double chiSquare(int[] expected, int[] observed) {
        double sumSq = 0.0;
        double dev = 0.0;
        for (int i = 0; i < observed.length; ++i) {
            dev = observed[i] - expected[i];
            sumSq += dev * dev / (double)expected[i];
        }
        return sumSq;
    }

    public void testLang100() throws Exception {
        int size = 5000;
        String encoding = "UTF-8";
        String orig = RandomStringUtils.random((int)size);
        byte[] bytes = orig.getBytes(encoding);
        String copy = new String(bytes, encoding);
        for (int i = 0; i < orig.length() && i < copy.length(); ++i) {
            char o = orig.charAt(i);
            char c = copy.charAt(i);
            RandomStringUtilsTest.assertEquals((String)("differs at " + i + "(" + Integer.toHexString(new Character(o).hashCode()) + "," + Integer.toHexString(new Character(c).hashCode()) + ")"), (char)o, (char)c);
        }
        RandomStringUtilsTest.assertEquals((int)orig.length(), (int)copy.length());
        RandomStringUtilsTest.assertEquals((String)orig, (String)copy);
    }
}

