/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleUtilsTest
extends TestCase {
    private static final Locale LOCALE_EN = new Locale("en", "");
    private static final Locale LOCALE_EN_US = new Locale("en", "US");
    private static final Locale LOCALE_EN_US_ZZZZ = new Locale("en", "US", "ZZZZ");
    private static final Locale LOCALE_FR = new Locale("fr", "");
    private static final Locale LOCALE_FR_CA = new Locale("fr", "CA");
    private static final Locale LOCALE_QQ = new Locale("qq", "");
    private static final Locale LOCALE_QQ_ZZ = new Locale("qq", "ZZ");

    public LocaleUtilsTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        LocaleUtils.isAvailableLocale((Locale)Locale.getDefault());
    }

    public void testConstructor() {
        LocaleUtilsTest.assertNotNull((Object)new LocaleUtils());
        Constructor<?>[] cons = LocaleUtils.class.getDeclaredConstructors();
        LocaleUtilsTest.assertEquals((int)1, (int)cons.length);
        LocaleUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        LocaleUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(LocaleUtils.class.getModifiers()));
        LocaleUtilsTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(LocaleUtils.class.getModifiers()));
    }

    private void assertValidToLocale(String language) {
        Locale locale = LocaleUtils.toLocale((String)language);
        LocaleUtilsTest.assertNotNull((String)"valid locale", (Object)locale);
        LocaleUtilsTest.assertEquals((String)language, (String)locale.getLanguage());
        LocaleUtilsTest.assertTrue((locale.getCountry() == null || locale.getCountry().length() == 0 ? 1 : 0) != 0);
        LocaleUtilsTest.assertTrue((locale.getVariant() == null || locale.getVariant().length() == 0 ? 1 : 0) != 0);
    }

    private void assertValidToLocale(String localeString, String language, String country) {
        Locale locale = LocaleUtils.toLocale((String)localeString);
        LocaleUtilsTest.assertNotNull((String)"valid locale", (Object)locale);
        LocaleUtilsTest.assertEquals((String)language, (String)locale.getLanguage());
        LocaleUtilsTest.assertEquals((String)country, (String)locale.getCountry());
        LocaleUtilsTest.assertTrue((locale.getVariant() == null || locale.getVariant().length() == 0 ? 1 : 0) != 0);
    }

    private void assertValidToLocale(String localeString, String language, String country, String variant) {
        Locale locale = LocaleUtils.toLocale((String)localeString);
        LocaleUtilsTest.assertNotNull((String)"valid locale", (Object)locale);
        LocaleUtilsTest.assertEquals((String)language, (String)locale.getLanguage());
        LocaleUtilsTest.assertEquals((String)country, (String)locale.getCountry());
        LocaleUtilsTest.assertEquals((String)variant, (String)locale.getVariant());
    }

    public void testToLocale_1Part() {
        LocaleUtilsTest.assertEquals(null, (Object)LocaleUtils.toLocale((String)null));
        this.assertValidToLocale("us");
        this.assertValidToLocale("fr");
        this.assertValidToLocale("de");
        this.assertValidToLocale("zh");
        this.assertValidToLocale("qq");
        try {
            LocaleUtils.toLocale((String)"Us");
            LocaleUtilsTest.fail((String)"Should fail if not lowercase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"US");
            LocaleUtilsTest.fail((String)"Should fail if not lowercase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"uS");
            LocaleUtilsTest.fail((String)"Should fail if not lowercase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"u#");
            LocaleUtilsTest.fail((String)"Should fail if not lowercase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"u");
            LocaleUtilsTest.fail((String)"Must be 2 chars if less than 5");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"uuu");
            LocaleUtilsTest.fail((String)"Must be 2 chars if less than 5");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"uu_U");
            LocaleUtilsTest.fail((String)"Must be 2 chars if less than 5");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToLocale_2Part() {
        this.assertValidToLocale("us_EN", "us", "EN");
        this.assertValidToLocale("us_ZH", "us", "ZH");
        try {
            LocaleUtils.toLocale((String)"us-EN");
            LocaleUtilsTest.fail((String)"Should fail as not underscore");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"us_En");
            LocaleUtilsTest.fail((String)"Should fail second part not uppercase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"us_en");
            LocaleUtilsTest.fail((String)"Should fail second part not uppercase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"us_eN");
            LocaleUtilsTest.fail((String)"Should fail second part not uppercase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"uS_EN");
            LocaleUtilsTest.fail((String)"Should fail first part not lowercase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"us_E3");
            LocaleUtilsTest.fail((String)"Should fail second part not uppercase");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToLocale_3Part() {
        this.assertValidToLocale("us_EN_A", "us", "EN", "A");
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4)) {
            this.assertValidToLocale("us_EN_a", "us", "EN", "a");
            this.assertValidToLocale("us_EN_SFsafdFDsdfF", "us", "EN", "SFsafdFDsdfF");
        } else {
            this.assertValidToLocale("us_EN_a", "us", "EN", "A");
            this.assertValidToLocale("us_EN_SFsafdFDsdfF", "us", "EN", "SFSAFDFDSDFF");
        }
        try {
            LocaleUtils.toLocale((String)"us_EN-a");
            LocaleUtilsTest.fail((String)"Should fail as not underscore");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"uu_UU_");
            LocaleUtilsTest.fail((String)"Must be 3, 5 or 7+ in length");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertLocaleLookupList(Locale locale, Locale defaultLocale, Locale[] expected) {
        List localeList = defaultLocale == null ? LocaleUtils.localeLookupList((Locale)locale) : LocaleUtils.localeLookupList((Locale)locale, (Locale)defaultLocale);
        LocaleUtilsTest.assertEquals((int)expected.length, (int)localeList.size());
        LocaleUtilsTest.assertEquals(Arrays.asList(expected), (Object)localeList);
        LocaleUtilsTest.assertUnmodifiableCollection(localeList);
    }

    public void testLocaleLookupList_Locale() {
        this.assertLocaleLookupList(null, null, new Locale[0]);
        this.assertLocaleLookupList(LOCALE_QQ, null, new Locale[]{LOCALE_QQ});
        this.assertLocaleLookupList(LOCALE_EN, null, new Locale[]{LOCALE_EN});
        this.assertLocaleLookupList(LOCALE_EN, null, new Locale[]{LOCALE_EN});
        this.assertLocaleLookupList(LOCALE_EN_US, null, new Locale[]{LOCALE_EN_US, LOCALE_EN});
        this.assertLocaleLookupList(LOCALE_EN_US_ZZZZ, null, new Locale[]{LOCALE_EN_US_ZZZZ, LOCALE_EN_US, LOCALE_EN});
    }

    public void testLocaleLookupList_LocaleLocale() {
        this.assertLocaleLookupList(LOCALE_QQ, LOCALE_QQ, new Locale[]{LOCALE_QQ});
        this.assertLocaleLookupList(LOCALE_EN, LOCALE_EN, new Locale[]{LOCALE_EN});
        this.assertLocaleLookupList(LOCALE_EN_US, LOCALE_EN_US, new Locale[]{LOCALE_EN_US, LOCALE_EN});
        this.assertLocaleLookupList(LOCALE_EN_US, LOCALE_QQ, new Locale[]{LOCALE_EN_US, LOCALE_EN, LOCALE_QQ});
        this.assertLocaleLookupList(LOCALE_EN_US, LOCALE_QQ_ZZ, new Locale[]{LOCALE_EN_US, LOCALE_EN, LOCALE_QQ_ZZ});
        this.assertLocaleLookupList(LOCALE_EN_US_ZZZZ, null, new Locale[]{LOCALE_EN_US_ZZZZ, LOCALE_EN_US, LOCALE_EN});
        this.assertLocaleLookupList(LOCALE_EN_US_ZZZZ, LOCALE_EN_US_ZZZZ, new Locale[]{LOCALE_EN_US_ZZZZ, LOCALE_EN_US, LOCALE_EN});
        this.assertLocaleLookupList(LOCALE_EN_US_ZZZZ, LOCALE_QQ, new Locale[]{LOCALE_EN_US_ZZZZ, LOCALE_EN_US, LOCALE_EN, LOCALE_QQ});
        this.assertLocaleLookupList(LOCALE_EN_US_ZZZZ, LOCALE_QQ_ZZ, new Locale[]{LOCALE_EN_US_ZZZZ, LOCALE_EN_US, LOCALE_EN, LOCALE_QQ_ZZ});
        this.assertLocaleLookupList(LOCALE_FR_CA, LOCALE_EN, new Locale[]{LOCALE_FR_CA, LOCALE_FR, LOCALE_EN});
    }

    public void testAvailableLocaleList() {
        List list = LocaleUtils.availableLocaleList();
        List list2 = LocaleUtils.availableLocaleList();
        LocaleUtilsTest.assertNotNull((Object)list);
        LocaleUtilsTest.assertSame((Object)list, (Object)list2);
        LocaleUtilsTest.assertUnmodifiableCollection(list);
        Locale[] jdkLocaleArray = Locale.getAvailableLocales();
        List<Locale> jdkLocaleList = Arrays.asList(jdkLocaleArray);
        LocaleUtilsTest.assertEquals(jdkLocaleList, (Object)list);
    }

    public void testAvailableLocaleSet() {
        Set set = LocaleUtils.availableLocaleSet();
        Set set2 = LocaleUtils.availableLocaleSet();
        LocaleUtilsTest.assertNotNull((Object)set);
        LocaleUtilsTest.assertSame((Object)set, (Object)set2);
        LocaleUtilsTest.assertUnmodifiableCollection(set);
        Locale[] jdkLocaleArray = Locale.getAvailableLocales();
        List<Locale> jdkLocaleList = Arrays.asList(jdkLocaleArray);
        HashSet<Locale> jdkLocaleSet = new HashSet<Locale>(jdkLocaleList);
        LocaleUtilsTest.assertEquals(jdkLocaleSet, (Object)set);
    }

    public void testIsAvailableLocale() {
        Set set = LocaleUtils.availableLocaleSet();
        LocaleUtilsTest.assertEquals((boolean)set.contains(LOCALE_EN), (boolean)LocaleUtils.isAvailableLocale((Locale)LOCALE_EN));
        LocaleUtilsTest.assertEquals((boolean)set.contains(LOCALE_EN_US), (boolean)LocaleUtils.isAvailableLocale((Locale)LOCALE_EN_US));
        LocaleUtilsTest.assertEquals((boolean)set.contains(LOCALE_EN_US_ZZZZ), (boolean)LocaleUtils.isAvailableLocale((Locale)LOCALE_EN_US_ZZZZ));
        LocaleUtilsTest.assertEquals((boolean)set.contains(LOCALE_FR), (boolean)LocaleUtils.isAvailableLocale((Locale)LOCALE_FR));
        LocaleUtilsTest.assertEquals((boolean)set.contains(LOCALE_FR_CA), (boolean)LocaleUtils.isAvailableLocale((Locale)LOCALE_FR_CA));
        LocaleUtilsTest.assertEquals((boolean)set.contains(LOCALE_QQ), (boolean)LocaleUtils.isAvailableLocale((Locale)LOCALE_QQ));
        LocaleUtilsTest.assertEquals((boolean)set.contains(LOCALE_QQ_ZZ), (boolean)LocaleUtils.isAvailableLocale((Locale)LOCALE_QQ_ZZ));
    }

    private void assertLanguageByCountry(String country, String[] languages) {
        List list = LocaleUtils.languagesByCountry((String)country);
        List list2 = LocaleUtils.languagesByCountry((String)country);
        LocaleUtilsTest.assertNotNull((Object)list);
        LocaleUtilsTest.assertSame((Object)list, (Object)list2);
        for (String language : languages) {
            Iterator iterator = list.iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                Locale locale = (Locale)iterator.next();
                LocaleUtilsTest.assertTrue((locale.getVariant() == null || locale.getVariant().length() == 0 ? 1 : 0) != 0);
                LocaleUtilsTest.assertEquals((String)country, (String)locale.getCountry());
                if (!language.equals(locale.getLanguage())) continue;
                found = true;
                break;
            }
            if (found) continue;
            LocaleUtilsTest.fail((String)("Cound not find language: " + language + " for country: " + country));
        }
        LocaleUtilsTest.assertUnmodifiableCollection(list);
    }

    public void testLanguagesByCountry() {
        this.assertLanguageByCountry(null, new String[0]);
        this.assertLanguageByCountry("GB", new String[]{"en"});
        this.assertLanguageByCountry("ZZ", new String[0]);
        this.assertLanguageByCountry("CH", new String[]{"fr", "de", "it"});
    }

    private void assertCountriesByLanguage(String language, String[] countries) {
        List list = LocaleUtils.countriesByLanguage((String)language);
        List list2 = LocaleUtils.countriesByLanguage((String)language);
        LocaleUtilsTest.assertNotNull((Object)list);
        LocaleUtilsTest.assertSame((Object)list, (Object)list2);
        for (String countrie : countries) {
            Iterator iterator = list.iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                Locale locale = (Locale)iterator.next();
                LocaleUtilsTest.assertTrue((locale.getVariant() == null || locale.getVariant().length() == 0 ? 1 : 0) != 0);
                LocaleUtilsTest.assertEquals((String)language, (String)locale.getLanguage());
                if (!countrie.equals(locale.getCountry())) continue;
                found = true;
                break;
            }
            if (found) continue;
            LocaleUtilsTest.fail((String)("Cound not find language: " + countrie + " for country: " + language));
        }
        LocaleUtilsTest.assertUnmodifiableCollection(list);
    }

    public void testCountriesByLanguage() {
        this.assertCountriesByLanguage(null, new String[0]);
        this.assertCountriesByLanguage("de", new String[]{"DE", "CH", "AT", "LU"});
        this.assertCountriesByLanguage("zz", new String[0]);
        this.assertCountriesByLanguage("it", new String[]{"IT", "CH"});
    }

    private static void assertUnmodifiableCollection(Collection<?> coll) {
        try {
            coll.add(null);
            LocaleUtilsTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testLang328() {
        this.assertValidToLocale("fr__POSIX", "fr", "", "POSIX");
    }
}

