/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import junit.framework.TestCase;
import org.apache.commons.lang3.CharSetUtils;

public class CharSetUtilsTest
extends TestCase {
    public CharSetUtilsTest(String name) {
        super(name);
    }

    public void testConstructor() {
        CharSetUtilsTest.assertNotNull((Object)new CharSetUtils());
        Constructor<?>[] cons = CharSetUtils.class.getDeclaredConstructors();
        CharSetUtilsTest.assertEquals((int)1, (int)cons.length);
        CharSetUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        CharSetUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(CharSetUtils.class.getModifiers()));
        CharSetUtilsTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(CharSetUtils.class.getModifiers()));
    }

    public void testSqueeze_StringString() {
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.squeeze(null, (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.squeeze(null, (String[])new String[]{""}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.squeeze((String)"", (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.squeeze((String)"", (String[])new String[]{""}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.squeeze((String)"", (String[])new String[]{"a-e"}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.squeeze((String)"hello", (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.squeeze((String)"hello", (String[])new String[]{""}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.squeeze((String)"hello", (String[])new String[]{"a-e"}));
        CharSetUtilsTest.assertEquals((String)"helo", (String)CharSetUtils.squeeze((String)"hello", (String[])new String[]{"l-p"}));
        CharSetUtilsTest.assertEquals((String)"heloo", (String)CharSetUtils.squeeze((String)"helloo", (String[])new String[]{"l"}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.squeeze((String)"helloo", (String[])new String[]{"^l"}));
    }

    public void testSqueeze_StringStringarray() {
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.squeeze(null, (String[])null));
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.squeeze(null, (String[])new String[0]));
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.squeeze(null, (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.squeeze(null, (String[])new String[]{"el"}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.squeeze((String)"", (String[])null));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.squeeze((String)"", (String[])new String[0]));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.squeeze((String)"", (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.squeeze((String)"", (String[])new String[]{"a-e"}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.squeeze((String)"hello", (String[])null));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.squeeze((String)"hello", (String[])new String[0]));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.squeeze((String)"hello", (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.squeeze((String)"hello", (String[])new String[]{"a-e"}));
        CharSetUtilsTest.assertEquals((String)"helo", (String)CharSetUtils.squeeze((String)"hello", (String[])new String[]{"el"}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.squeeze((String)"hello", (String[])new String[]{"e"}));
        CharSetUtilsTest.assertEquals((String)"fofof", (String)CharSetUtils.squeeze((String)"fooffooff", (String[])new String[]{"of"}));
        CharSetUtilsTest.assertEquals((String)"fof", (String)CharSetUtils.squeeze((String)"fooooff", (String[])new String[]{"fo"}));
    }

    public void testCount_StringString() {
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count(null, (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count(null, (String[])new String[]{""}));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count((String)"", (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count((String)"", (String[])new String[]{""}));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count((String)"", (String[])new String[]{"a-e"}));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count((String)"hello", (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count((String)"hello", (String[])new String[]{""}));
        CharSetUtilsTest.assertEquals((int)1, (int)CharSetUtils.count((String)"hello", (String[])new String[]{"a-e"}));
        CharSetUtilsTest.assertEquals((int)3, (int)CharSetUtils.count((String)"hello", (String[])new String[]{"l-p"}));
    }

    public void testCount_StringStringarray() {
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count(null, (String[])null));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count(null, (String[])new String[0]));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count(null, (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count(null, (String[])new String[]{"a-e"}));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count((String)"", (String[])null));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count((String)"", (String[])new String[0]));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count((String)"", (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count((String)"", (String[])new String[]{"a-e"}));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count((String)"hello", (String[])null));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count((String)"hello", (String[])new String[0]));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count((String)"hello", (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((int)1, (int)CharSetUtils.count((String)"hello", (String[])new String[]{"a-e"}));
        CharSetUtilsTest.assertEquals((int)3, (int)CharSetUtils.count((String)"hello", (String[])new String[]{"el"}));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count((String)"hello", (String[])new String[]{"x"}));
        CharSetUtilsTest.assertEquals((int)2, (int)CharSetUtils.count((String)"hello", (String[])new String[]{"e-i"}));
        CharSetUtilsTest.assertEquals((int)5, (int)CharSetUtils.count((String)"hello", (String[])new String[]{"a-z"}));
        CharSetUtilsTest.assertEquals((int)0, (int)CharSetUtils.count((String)"hello", (String[])new String[]{""}));
    }

    public void testKeep_StringString() {
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.keep(null, (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.keep(null, (String[])new String[]{""}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.keep((String)"", (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.keep((String)"", (String[])new String[]{""}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.keep((String)"", (String[])new String[]{"a-e"}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.keep((String)"hello", (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.keep((String)"hello", (String[])new String[]{""}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.keep((String)"hello", (String[])new String[]{"xyz"}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.keep((String)"hello", (String[])new String[]{"a-z"}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.keep((String)"hello", (String[])new String[]{"oleh"}));
        CharSetUtilsTest.assertEquals((String)"ell", (String)CharSetUtils.keep((String)"hello", (String[])new String[]{"el"}));
    }

    public void testKeep_StringStringarray() {
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.keep(null, (String[])null));
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.keep(null, (String[])new String[0]));
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.keep(null, (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.keep(null, (String[])new String[]{"a-e"}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.keep((String)"", (String[])null));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.keep((String)"", (String[])new String[0]));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.keep((String)"", (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.keep((String)"", (String[])new String[]{"a-e"}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.keep((String)"hello", (String[])null));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.keep((String)"hello", (String[])new String[0]));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.keep((String)"hello", (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((String)"e", (String)CharSetUtils.keep((String)"hello", (String[])new String[]{"a-e"}));
        CharSetUtilsTest.assertEquals((String)"e", (String)CharSetUtils.keep((String)"hello", (String[])new String[]{"a-e"}));
        CharSetUtilsTest.assertEquals((String)"ell", (String)CharSetUtils.keep((String)"hello", (String[])new String[]{"el"}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.keep((String)"hello", (String[])new String[]{"elho"}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.keep((String)"hello", (String[])new String[]{"a-z"}));
        CharSetUtilsTest.assertEquals((String)"----", (String)CharSetUtils.keep((String)"----", (String[])new String[]{"-"}));
        CharSetUtilsTest.assertEquals((String)"ll", (String)CharSetUtils.keep((String)"hello", (String[])new String[]{"l"}));
    }

    public void testDelete_StringString() {
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.delete(null, (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.delete(null, (String[])new String[]{""}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.delete((String)"", (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.delete((String)"", (String[])new String[]{""}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.delete((String)"", (String[])new String[]{"a-e"}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.delete((String)"hello", (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.delete((String)"hello", (String[])new String[]{""}));
        CharSetUtilsTest.assertEquals((String)"hllo", (String)CharSetUtils.delete((String)"hello", (String[])new String[]{"a-e"}));
        CharSetUtilsTest.assertEquals((String)"he", (String)CharSetUtils.delete((String)"hello", (String[])new String[]{"l-p"}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.delete((String)"hello", (String[])new String[]{"z"}));
    }

    public void testDelete_StringStringarray() {
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.delete(null, (String[])null));
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.delete(null, (String[])new String[0]));
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.delete(null, (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals(null, (String)CharSetUtils.delete(null, (String[])new String[]{"el"}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.delete((String)"", (String[])null));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.delete((String)"", (String[])new String[0]));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.delete((String)"", (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.delete((String)"", (String[])new String[]{"a-e"}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.delete((String)"hello", (String[])null));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.delete((String)"hello", (String[])new String[0]));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.delete((String)"hello", (String[])new String[]{null}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.delete((String)"hello", (String[])new String[]{"xyz"}));
        CharSetUtilsTest.assertEquals((String)"ho", (String)CharSetUtils.delete((String)"hello", (String[])new String[]{"el"}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.delete((String)"hello", (String[])new String[]{"elho"}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.delete((String)"hello", (String[])new String[]{""}));
        CharSetUtilsTest.assertEquals((String)"hello", (String)CharSetUtils.delete((String)"hello", (String[])new String[]{""}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.delete((String)"hello", (String[])new String[]{"a-z"}));
        CharSetUtilsTest.assertEquals((String)"", (String)CharSetUtils.delete((String)"----", (String[])new String[]{"-"}));
        CharSetUtilsTest.assertEquals((String)"heo", (String)CharSetUtils.delete((String)"hello", (String[])new String[]{"l"}));
    }
}

