/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import junit.framework.TestCase;
import org.apache.commons.lang3.CharEncoding;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;

public class CharEncodingTest
extends TestCase {
    private void assertSupportedEncoding(String name) {
        CharEncodingTest.assertTrue((String)("Encoding should be supported: " + name), (boolean)CharEncoding.isSupported((String)name));
    }

    public void testConstructor() {
        new CharEncoding();
    }

    public void testMustBeSupportedJava1_3_1() {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3)) {
            this.assertSupportedEncoding("ISO-8859-1");
            this.assertSupportedEncoding("US-ASCII");
            this.assertSupportedEncoding("UTF-16");
            this.assertSupportedEncoding("UTF-16BE");
            this.assertSupportedEncoding("UTF-16LE");
            this.assertSupportedEncoding("UTF-8");
        } else {
            this.warn("Java 1.3 tests not run since the current version is " + SystemUtils.JAVA_SPECIFICATION_VERSION);
        }
    }

    public void testSupported() {
        CharEncodingTest.assertTrue((boolean)CharEncoding.isSupported((String)"UTF8"));
        CharEncodingTest.assertTrue((boolean)CharEncoding.isSupported((String)"UTF-8"));
        CharEncodingTest.assertTrue((boolean)CharEncoding.isSupported((String)"ASCII"));
    }

    public void testNotSupported() {
        CharEncodingTest.assertFalse((boolean)CharEncoding.isSupported(null));
        CharEncodingTest.assertFalse((boolean)CharEncoding.isSupported((String)""));
        CharEncodingTest.assertFalse((boolean)CharEncoding.isSupported((String)" "));
        CharEncodingTest.assertFalse((boolean)CharEncoding.isSupported((String)"\t\r\n"));
        CharEncodingTest.assertFalse((boolean)CharEncoding.isSupported((String)"DOESNOTEXIST"));
        CharEncodingTest.assertFalse((boolean)CharEncoding.isSupported((String)"this is not a valid encoding name"));
    }

    public void testWorksOnJava1_1_8() {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1)) {
            this.assertSupportedEncoding("ISO-8859-1");
            this.assertSupportedEncoding("US-ASCII");
            this.assertSupportedEncoding("UTF-8");
        } else {
            this.warn("Java 1.1 tests not run since the current version is " + SystemUtils.JAVA_SPECIFICATION_VERSION);
        }
    }

    public void testWorksOnJava1_2_2() {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2)) {
            this.assertSupportedEncoding("ISO-8859-1");
            this.assertSupportedEncoding("US-ASCII");
            this.assertSupportedEncoding("UTF-8");
        } else {
            this.warn("Java 1.2 tests not run since the current version is " + SystemUtils.JAVA_SPECIFICATION_VERSION);
        }
    }

    void warn(String msg) {
        System.err.println(msg);
    }
}

