/*
 * Decompiled with CFR 0.152.
 */
package jcmpltest;

import jCMPL.Cmpl;
import jCMPL.CmplException;
import jCMPL.CmplParameter;
import jCMPL.CmplSet;
import jCMPL.CmplSolArray;
import jCMPL.CmplSolElement;
import java.util.ArrayList;
import java.util.Iterator;

public class Transportation {
    public static void main(String[] stringArray) throws CmplException {
        try {
            Cmpl cmpl = new Cmpl("transportation.cmpl");
            CmplSet cmplSet = new CmplSet("routes", 2);
            int[][] nArrayArray = new int[][]{{1, 1}, {1, 2}, {1, 4}, {2, 2}, {2, 3}, {2, 4}, {3, 1}, {3, 3}};
            cmplSet.setValues(nArrayArray);
            CmplSet cmplSet2 = new CmplSet("plants");
            cmplSet2.setValues(1, 3);
            CmplSet cmplSet3 = new CmplSet("centers");
            cmplSet3.setValues(1, 1, 4);
            CmplParameter cmplParameter = new CmplParameter("c", cmplSet);
            Integer[] integerArray = new Integer[]{3, 2, 6, 5, 2, 3, 2, 4};
            cmplParameter.setValues(integerArray);
            CmplParameter cmplParameter2 = new CmplParameter("s", cmplSet2);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(5000);
            arrayList.add(6000);
            arrayList.add(2500);
            cmplParameter2.setValues(arrayList);
            CmplParameter cmplParameter3 = new CmplParameter("d", cmplSet3);
            int[] nArray = new int[]{6000, 4000, 2000, 2500};
            cmplParameter3.setValues(nArray);
            cmpl.setSets(cmplSet, cmplSet2, cmplSet3);
            cmpl.setParameters(cmplParameter, cmplParameter2, cmplParameter3);
            cmpl.setOutput(true);
            cmpl.setOption("%arg -solver cbc");
            cmpl.connect("http://127.0.0.1:8008");
            cmpl.solve();
            if (cmpl.solverStatus() == 4) {
                cmpl.solutionReport();
                System.out.println("Objective name      :" + cmpl.objectiveName());
                System.out.println("Nr. of Variables    :" + cmpl.nrOfVariables());
                System.out.println("Nr. of Constraints  :" + cmpl.nrOfConstraints());
                System.out.println("Nr. of Solutions    :" + cmpl.nrOfSolutions());
                System.out.println("Display variables   :" + cmpl.varDisplayOptions());
                System.out.println("Display constraints :" + cmpl.varDisplayOptions());
                System.out.println("Solution nr.        :" + (cmpl.solution().idx() + 1));
                System.out.println("Objective value     :" + cmpl.solution().value() + " " + cmpl.objectiveSense());
                for (CmplSolElement object : cmpl.solution().variables()) {
                    System.out.println(object.idx() + " " + object.name() + " " + object.type() + " " + object.activity() + " " + object.lowerBound() + " " + object.upperBound() + " " + object.marginal());
                }
                for (CmplSolElement cmplSolElement : cmpl.solution().constraints()) {
                    System.out.println(cmplSolElement.idx() + " " + cmplSolElement.name() + " " + cmplSolElement.type() + " " + cmplSolElement.activity() + " " + cmplSolElement.lowerBound() + " " + cmplSolElement.upperBound() + " " + cmplSolElement.marginal());
                }
            } else {
                System.out.println("Solver failed " + cmpl.solver() + " " + cmpl.solverMessage());
            }
            Iterator<CmplSolElement> iterator = (CmplSolArray)cmpl.getVarByName("x");
            for (int[] nArray2 : (int[][])cmplSet.values()) {
                System.out.print(String.valueOf(nArray2[0]) + " " + String.valueOf(nArray2[1]) + " ");
                System.out.println(((CmplSolArray)((Object)iterator)).get((Object)nArray2).activity());
            }
        }
        catch (CmplException cmplException) {
            System.out.println(cmplException);
        }
    }
}

