/*
 * Decompiled with CFR 0.152.
 */
package jcmpltest;

import jCMPL.Cmpl;
import jCMPL.CmplException;
import jCMPL.CmplParameter;
import jCMPL.CmplSet;
import jCMPL.CmplSolArray;
import jCMPL.CmplSolElement;
import jCMPL.CmplSolution;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class Diet {
    public Diet(String string, int n) throws CmplException {
        try {
            Cmpl cmpl = new Cmpl("diet.cmpl");
            CmplSet cmplSet = new CmplSet("NUTR");
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("A");
            arrayList.add("B1");
            arrayList.add("B2");
            arrayList.add("C");
            cmplSet.setValues(arrayList);
            CmplSet cmplSet2 = new CmplSet("FOOD");
            String[] stringArray = new String[]{"BEEF", "CHK", "FISH", "HAM", "MCH", "MTL", "SPG", "TUR"};
            cmplSet2.setValues(stringArray);
            CmplParameter cmplParameter = new CmplParameter("costs", cmplSet2);
            Double[] doubleArray = new Double[]{3.19, 2.59, 2.29, 2.89, 1.89, 1.99, 1.99, 2.49};
            cmplParameter.setValues(doubleArray);
            CmplParameter cmplParameter2 = new CmplParameter("vitMin", cmplSet);
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            arrayList2.add(700);
            arrayList2.add(700);
            arrayList2.add(700);
            arrayList2.add(700);
            cmplParameter2.setValues(arrayList2);
            CmplParameter cmplParameter3 = new CmplParameter("vitamin", cmplSet, cmplSet2);
            int[][] nArrayArray = new int[][]{{60, 8, 8, 40, 15, 70, 25, 60}, {20, 0, 10, 40, 35, 30, 50, 20}, {10, 20, 15, 35, 15, 15, 25, 15}, {15, 20, 10, 10, 15, 15, 15, 10}};
            cmplParameter3.setValues(nArrayArray);
            cmpl.setSets(cmplSet, cmplSet2);
            cmpl.setParameters(cmplParameter, cmplParameter2, cmplParameter3);
            cmpl.setOption("%arg -solver glpk");
            if (n == 1) {
                cmpl.connect("http://127.0.0.1:9999");
            }
            cmpl.solve();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string + ".stdout"));
            if (cmpl.solverStatus() == 4) {
                bufferedWriter.write("Objective name      :" + cmpl.objectiveName() + "\n");
                bufferedWriter.write("Nr. of Variables    :" + cmpl.nrOfVariables() + "\n");
                bufferedWriter.write("Nr. of Constraints  :" + cmpl.nrOfConstraints() + "\n");
                bufferedWriter.write("Nr. of Solutions    :" + cmpl.nrOfSolutions() + "\n");
                bufferedWriter.write("Display variables   :" + cmpl.varDisplayOptions() + "\n");
                bufferedWriter.write("Display constraints :" + cmpl.varDisplayOptions() + "\n");
                for (CmplSolution object : cmpl.solutionPool()) {
                    bufferedWriter.write("Solution nr.        :" + (object.idx() + 1) + "\n");
                    bufferedWriter.write("Objective value     :" + object.value() + " " + cmpl.objectiveSense() + "\n");
                    for (CmplSolElement cmplSolElement : object.variables()) {
                        bufferedWriter.write(cmplSolElement.idx() + " " + cmplSolElement.name() + " " + cmplSolElement.type() + " " + cmplSolElement.activity() + " " + cmplSolElement.lowerBound() + " " + cmplSolElement.upperBound() + " " + cmplSolElement.marginal() + "\n");
                    }
                    for (CmplSolElement cmplSolElement : object.constraints()) {
                        bufferedWriter.write(cmplSolElement.idx() + " " + cmplSolElement.name() + " " + cmplSolElement.type() + " " + cmplSolElement.activity() + " " + cmplSolElement.lowerBound() + " " + cmplSolElement.upperBound() + " " + cmplSolElement.marginal() + "\n");
                    }
                }
                bufferedWriter.write("Solution nr.        :" + (cmpl.solution().idx() + 1) + "\n");
                bufferedWriter.write("Objective value     :" + cmpl.solution().value() + " " + cmpl.objectiveSense() + "\n");
                for (CmplSolElement cmplSolElement : cmpl.solution().variables()) {
                    bufferedWriter.write(cmplSolElement.idx() + " " + cmplSolElement.name() + " " + cmplSolElement.type() + " " + cmplSolElement.activity() + " " + cmplSolElement.lowerBound() + " " + cmplSolElement.upperBound() + " " + cmplSolElement.marginal() + "\n");
                }
                for (CmplSolElement cmplSolElement : cmpl.solution().constraints()) {
                    bufferedWriter.write(cmplSolElement.idx() + " " + cmplSolElement.name() + " " + cmplSolElement.type() + " " + cmplSolElement.activity() + " " + cmplSolElement.lowerBound() + " " + cmplSolElement.upperBound() + " " + cmplSolElement.marginal() + "\n");
                }
                cmpl.saveSolution(string + ".csol");
                cmpl.saveSolutionAscii(string + ".sol");
                cmpl.saveSolutionCsv(string + ".csv");
                CmplSolArray cmplSolArray = (CmplSolArray)cmpl.getVarByName("x");
                bufferedWriter.write(cmplSolArray.get((Object)"BEEF").activity() + "\n");
            } else {
                bufferedWriter.write("Solver failed " + cmpl.solver() + " " + cmpl.solverMessage());
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("IO error for test diet  " + iOException);
        }
        catch (CmplException cmplException) {
            System.out.println(cmplException);
        }
    }
}

