/* $Id: CoinPresolveIsolated.hpp 1191 2009-07-25 08:38:12Z forrest $ */
// Copyright (C) 2002, International Business Machines
// Corporation and others.  All Rights Reserved.

#ifndef CoinPresolveIsolated_H
#define CoinPresolveIsolated_H

#include "CoinPresolveMatrix.hpp"

class isolated_constraint_action : public CoinPresolveAction {
  isolated_constraint_action();
  isolated_constraint_action(const isolated_constraint_action& rhs);
  isolated_constraint_action& operator=(const isolated_constraint_action& rhs);

  double rlo_;
  double rup_;
  int row_;
  int ninrow_;
  // the arrays are owned by the class and must be deleted at destruction
  const int *rowcols_;
  const double *rowels_;
  const double *costs_;

  isolated_constraint_action(double rlo,
			     double rup,
			     int row,
			     int ninrow,
			     const int *rowcols,
			     const double *rowels,
			     const double *costs,
			     const CoinPresolveAction *next) :
    CoinPresolveAction(next),
    rlo_(rlo), rup_(rup), row_(row), ninrow_(ninrow),
    rowcols_(rowcols), rowels_(rowels), costs_(costs) {}
      
 public:
  const char *name() const;

  static const CoinPresolveAction *presolve(CoinPresolveMatrix * prob,
					 int row,
					 const CoinPresolveAction *next);

  void postsolve(CoinPostsolveMatrix *prob) const;

  ~isolated_constraint_action();
};



#endif
